/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.List;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.junit.Assert;
import org.junit.Test;

public class ObservationPeriodTestCase {
    @Test
    public void testValues() {
        Assert.assertEquals((Object)"1950", (Object)new ObservationPeriod("Y1950Q1").getYear());
        Assert.assertEquals((Object)"1950", (Object)new ObservationPeriod("1950Q1").getYear());
        Assert.assertEquals((Object)"1", (Object)new ObservationPeriod("Y1950Q1").getQuarter());
        Assert.assertEquals((Object)"12", (Object)new ObservationPeriod("Y1950M12").getMonth());
        Assert.assertEquals((Object)new ObservationPeriod("Y1950M12"), (Object)new ObservationPeriod("1950M12"));
        Assert.assertEquals((Object)new ObservationPeriod("Y1950M12").toString(), (Object)new ObservationPeriod("1950M12").toString());
        Assert.assertEquals((long)new ObservationPeriod("Y1950M12").hashCode(), (long)new ObservationPeriod("1950M12").hashCode());
    }

    @Test
    public void testResolutions() {
        Assert.assertEquals((Object)TimeResolution.YEAR, (Object)new ObservationPeriod("1930").getResolution());
        Assert.assertEquals((Object)TimeResolution.YEAR, (Object)new ObservationPeriod("1930").getResolution());
        Assert.assertEquals((Object)TimeResolution.QUARTER, (Object)new ObservationPeriod("Y1930Q1").getResolution());
        Assert.assertEquals((Object)TimeResolution.MONTH, (Object)new ObservationPeriod("Y1930M12").getResolution());
    }

    @Test
    public void testValid() {
        Assert.assertTrue((boolean)ObservationPeriod.isValid("Y1930", TimeResolution.YEAR));
        Assert.assertTrue((boolean)ObservationPeriod.isValid("Y1930M1", TimeResolution.MONTH));
        Assert.assertTrue((boolean)ObservationPeriod.isValid("Y1930Q1", TimeResolution.QUARTER));
    }

    @Test
    public void testGroups() throws Exception {
        ObservationPeriod period = new ObservationPeriod("1009Q3");
        Assert.assertEquals((Object)"1009", (Object)period.getYear());
        Assert.assertEquals((Object)"3", (Object)period.getQuarter());
        Assert.assertNull((Object)period.getMonth());
    }

    @Test
    public void testYearlyRange() throws Exception {
        List<ObservationPeriod> range = ObservationPeriod.parseRange("Y1999,Y1950,Y1951,Y1951,Y1960..Y1970", TimeResolution.YEAR);
        for (ObservationPeriod period : range) {
            System.out.println(period);
        }
    }

    @Test
    public void testValidRange() throws Exception {
        Assert.assertTrue((boolean)ObservationPeriod.isValidRange("Y1999M1,Y1950M2,Y1951M12,Y1951M4,Y1960M2..Y1970M3", TimeResolution.MONTH));
        Assert.assertTrue((boolean)ObservationPeriod.isValidRange("Y1999,Y2000", TimeResolution.YEAR));
    }

    @Test
    public void testOrdinalPosition() throws Exception {
        ObservationPeriod first = new ObservationPeriod("Y1950");
        ObservationPeriod second = new ObservationPeriod("Y1952");
        Assert.assertTrue((first.getOrdinalNumber() < second.getOrdinalNumber() ? 1 : 0) != 0);
    }

    @Test
    public void testISO8601() throws Exception {
        ObservationPeriod first = new ObservationPeriod("Y1950");
        ObservationPeriod second = new ObservationPeriod("Y1952Q2");
        ObservationPeriod third = new ObservationPeriod("Y1954M2");
        Assert.assertTrue((boolean)first.getISO8601().equals("1950"));
        Assert.assertTrue((boolean)second.getISO8601().equals("1952-04/P3M"));
        Assert.assertTrue((boolean)third.getISO8601().equals("1954-02"));
    }
}

