/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.api.io.csv;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceConceptCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.impl.ReferenceConceptCSVMetadataImpl;
import org.fao.fi.fishstat.data.api.io.csv.impl.ReferenceRelationshipCSVMetadataImpl;
import org.fao.fi.fishstat.data.api.io.exceptions.FSIOException;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.csv.ValidationResult;
import org.fao.fi.fishstat.data.common.api.csv.impl.ValidationReporter;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class ReferenceCSVService {
    private static ReferenceCSVService instance = null;

    public static ReferenceCSVService instance() {
        if (instance == null) {
            instance = new ReferenceCSVService();
        }
        return instance;
    }

    public void upload(Concept concept, Reader input, ReferenceConceptCSVMetadata metadata, boolean truncate) throws FSIOException {
        try {
            if (concept == null) {
                throw new FSIOException("Concept can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createConceptMetadata(concept);
            }
            List<ReferenceObject> loaded = this._upload(concept, input, metadata);
            if (truncate) {
                System.out.println("truncating...");
                concept.removeAll();
            }
            concept.addAll(loaded);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to load objects", e);
        }
    }

    public void download(Concept concept, Writer output, ReferenceConceptCSVMetadata metadata) throws FSIOException {
        try {
            if (concept == null) {
                throw new FSIOException("Concept can not be null");
            }
            if (output == null) {
                throw new FSIOException("Output CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createConceptMetadata(concept);
            }
            this._download(concept, output, metadata);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to download objects", e);
        }
    }

    private void _download(Concept concept, Writer output, ReferenceConceptCSVMetadata metadata) throws Exception {
        CsvWriter writer = new CsvWriter(output, ',');
        if (metadata.useHeaders()) {
            List<String> headers = metadata.getAttributeHeaders();
            writer.writeRecord(headers.toArray(new String[headers.size()]));
        }
        if (metadata.useTextQualifier()) {
            writer.setTextQualifier(metadata.getTextQualifier());
        }
        for (ReferenceObject object : concept.getObjects()) {
            ArrayList<String> record = new ArrayList<String>();
            for (Attribute attribute : concept.getAttributes()) {
                Object value = object.getAttribute(attribute);
                if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                    MultilingualString multi_string_value = (MultilingualString)value;
                    for (String language : MultilingualString.LANGUAGES) {
                        int column = metadata.getAttributeColumn(attribute.getAcronym(), language);
                        if (column == -1) continue;
                        record.add(column, multi_string_value.getValue(language));
                    }
                    continue;
                }
                int column = metadata.getAttributeColumn(attribute.getAcronym());
                if (column == -1) continue;
                record.add(column, value == null ? null : String.valueOf(value));
            }
            writer.writeRecord(record.toArray(new String[record.size()]));
        }
        writer.flush();
        writer.close();
    }

    public void download(Relationship relationship, Writer output, ReferenceRelationshipCSVMetadata metadata) throws FSIOException {
        try {
            if (relationship == null) {
                throw new FSIOException("Relationship can not be null");
            }
            if (output == null) {
                throw new FSIOException("Output CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createRelationshipMetadata();
            }
            this._download(relationship, output, metadata);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to download relationship", e);
        }
    }

    private void _download(Relationship relationship, Writer output, ReferenceRelationshipCSVMetadata metadata) throws Exception {
        CsvWriter writer = new CsvWriter(output, ',');
        if (metadata.useTextQualifier()) {
            writer.setTextQualifier(metadata.getTextQualifier());
        }
        Attribute parent_attribute = null;
        if (!(metadata.getParentAttribute() == null || metadata.getParentAttribute().equalsIgnoreCase("ID") || (parent_attribute = relationship.getParentConcept().getAttribute(metadata.getParentAttribute())) != null && parent_attribute.isCodeAttribute())) {
            throw new FSIOException("Parent reference attribute is not a valid (code) attribute for the concept: " + metadata.getParentAttribute());
        }
        Attribute child_attribute = null;
        if (!(metadata.getChildAttribute() == null || metadata.getChildAttribute().equalsIgnoreCase("ID") || (child_attribute = relationship.getChildConcept().getAttribute(metadata.getChildAttribute())) != null && child_attribute.isCodeAttribute())) {
            throw new FSIOException("Child reference attribute is not a valid (code) attribute for the concept: " + metadata.getChildAttribute());
        }
        ArrayList<String> headers = new ArrayList<String>();
        String header = metadata.getParentHeader();
        int column = metadata.getParentColumn();
        if (column != -1) {
            headers.add(column, header == null || header.length() == 0 ? "PARENT_ID" : header);
        } else {
            headers.add(header == null || header.length() == 0 ? "PARENT_ID" : header);
            metadata.setParentColumn(header.length() - 1);
        }
        header = metadata.getChildHeader();
        column = metadata.getChildColumn();
        if (column != -1) {
            headers.add(column, header == null || header.length() == 0 ? "CHILD_ID" : header);
        } else {
            headers.add(header == null || header.length() == 0 ? "CHILD_ID" : header);
            metadata.setChildColumn(header.length() - 1);
        }
        writer.writeRecord(headers.toArray(new String[headers.size()]));
        for (ReferenceObject parent : relationship.getParents()) {
            String parent_value = null;
            parent_value = parent_attribute != null ? String.valueOf(parent.getAttribute(parent_attribute)) : parent.getId().stringValue();
            if (parent_value == null) {
                throw new FSIOException("Parent reference attribute is null: " + parent);
            }
            for (ReferenceObject child : relationship.getChildren(parent)) {
                String child_value = null;
                child_value = child_attribute != null ? String.valueOf(child.getAttribute(child_attribute)) : child.getId().stringValue();
                if (child_value == null) {
                    throw new FSIOException("Child reference attribute is null: " + parent);
                }
                ArrayList<String> record = new ArrayList<String>();
                record.add(metadata.getParentColumn(), parent_value);
                record.add(metadata.getChildColumn(), child_value);
                writer.writeRecord(record.toArray(new String[record.size()]));
            }
        }
        writer.flush();
        writer.close();
    }

    private void checkHeaders(Relationship relationship, CsvReader reader, ReferenceRelationshipCSVMetadata metadata) throws Exception {
        List<String> headers = null;
        if (metadata.useHeaders()) {
            if (!reader.readHeaders()) {
                throw new FSIOException("CSV header could not be read");
            }
            headers = Arrays.asList(reader.getHeaders());
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        if (metadata.useHeaders()) {
            String parent_header = metadata.getParentHeader();
            if (parent_header == null) {
                throw new FSIOException("No CSV metadata header provided for parent attribute: " + metadata.getParentAttribute());
            }
            if (!headers.contains(parent_header)) {
                throw new FSIOException("Expected CSV metadata header not found: " + parent_header);
            }
            String child_header = metadata.getChildHeader();
            if (child_header == null) {
                throw new FSIOException("No CSV metadata header provided for child attribute: " + metadata.getChildAttribute());
            }
            if (!headers.contains(child_header)) {
                throw new FSIOException("Expected CSV metadata header not found: " + child_header);
            }
        } else {
            int column = metadata.getParentColumn();
            if (column == -1) {
                throw new FSIOException("No CSV metadata column provided for parent attribute: " + metadata.getParentAttribute());
            }
            if (column >= reader.getColumnCount()) {
                throw new FSIOException("CSV metadata column provided for parent attribute is out of bound: " + column);
            }
            column = metadata.getChildColumn();
            if (column == -1) {
                throw new FSIOException("No CSV metadata column provided for child attribute: " + metadata.getChildAttribute());
            }
            if (column >= reader.getColumnCount()) {
                throw new FSIOException("CSV metadata column provided for child attribute is out of bound: " + column);
            }
        }
    }

    private void checkHeaders(Concept concept, CsvReader reader, ReferenceConceptCSVMetadata metadata) throws Exception {
        List<String> headers = null;
        if (metadata.useHeaders()) {
            if (!reader.readHeaders()) {
                throw new FSIOException("CSV header could not be read");
            }
            headers = Arrays.asList(reader.getHeaders());
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        for (Attribute attribute : concept.getCodeAttributes()) {
            if (attribute.getAcronym().equals("ID")) continue;
            if (metadata.useHeaders()) {
                if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                    for (String lang : MultilingualString.LANGUAGES) {
                        String header = metadata.getAttributeHeader(attribute.getAcronym(), lang);
                        if (header == null) {
                            throw new FSIOException("No CSV metadata header provided for code attribute: " + attribute.getAcronym() + ", language:" + lang);
                        }
                        if (headers.contains(header)) continue;
                        throw new FSIOException("Expected CSV metadata header not found: " + header);
                    }
                    continue;
                }
                String header = metadata.getAttributeHeader(attribute.getAcronym());
                if (header == null) {
                    throw new FSIOException("No CSV metadata header provided for code attribute: " + attribute.getAcronym());
                }
                if (headers.contains(header)) continue;
                throw new FSIOException("Expected CSV metadata header not found: " + header);
            }
            if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                for (String lang : MultilingualString.LANGUAGES) {
                    int column = metadata.getAttributeColumn(attribute.getAcronym(), lang);
                    if (column == -1) {
                        throw new FSIOException("No CSV metadata column provided for code attribute: " + attribute.getAcronym() + ", language: " + lang);
                    }
                    if (column < reader.getColumnCount()) continue;
                    throw new FSIOException("CSV metadata column provided for code attribute: " + attribute.getAcronym() + ", language: " + lang + " is out of bound: " + column);
                }
                continue;
            }
            int column = metadata.getAttributeColumn(attribute.getAcronym());
            if (column == -1) {
                throw new FSIOException("No CSV metadata column provided for code attribute: " + attribute.getAcronym());
            }
            if (column < reader.getColumnCount()) continue;
            throw new FSIOException("CSV metadata column provided for code attribute: " + attribute.getAcronym() + " is out of bound: " + column);
        }
    }

    private List<ReferenceObject> _upload(Concept concept, Reader input, ReferenceConceptCSVMetadata metadata) throws Exception {
        ArrayList<ReferenceObject> loaded = new ArrayList<ReferenceObject>();
        CsvReader reader = new CsvReader(input, ',');
        if (metadata.useHeaders()) {
            reader.readHeaders();
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        while (reader.readRecord()) {
            try {
                System.out.println("loading record " + reader.getCurrentRecord());
                ReferenceObject object = concept.createObject();
                for (Attribute attribute : concept.getAttributes()) {
                    if (attribute.getAcronym().equals("ID")) continue;
                    Object attribute_value = null;
                    if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                        MultilingualString multi_string = new MultilingualString();
                        for (String lang : MultilingualString.LANGUAGES) {
                            String value = null;
                            if (metadata.useHeaders()) {
                                String header = metadata.getAttributeHeader(attribute.getAcronym(), lang);
                                value = reader.get(header);
                            } else {
                                int column = metadata.getAttributeColumn(attribute.getAcronym(), lang);
                                value = reader.get(column);
                            }
                            multi_string.setValue(lang, value);
                        }
                        attribute_value = multi_string;
                    } else {
                        String value = null;
                        if (metadata.useHeaders()) {
                            String header = metadata.getAttributeHeader(attribute.getAcronym());
                            value = reader.get(header);
                        } else {
                            int column = metadata.getAttributeColumn(attribute.getAcronym());
                            value = reader.get(column);
                        }
                        if (value != null) {
                            Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                            attribute_value = constructor.newInstance(value);
                        }
                    }
                    object.setAttribute(attribute, attribute_value);
                }
                loaded.add(object);
            }
            catch (Exception e) {
                if (reader != null) {
                    reader.close();
                }
                throw new FSIOException("Unable to unmarshall CSV row: " + e.getMessage(), e, reader.getCurrentRecord() + 1L);
            }
        }
        reader.close();
        return loaded;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ValidationResult validate(Concept concept, Reader input, ReferenceConceptCSVMetadata metadata, ILog log) {
        reporter = new ValidationReporter();
        try {
            if (concept == null) {
                throw new FSIOException("Concept can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createConceptMetadata(concept);
            }
            reader = new CsvReader(input, ',');
            this.checkHeaders(concept, reader, metadata);
            code_attributes_values = new HashMap<Attribute, HashSet<E>>();
            for (Attribute attribute : concept.getCodeAttributes()) {
                code_attributes_values.put(attribute, new HashSet<E>());
            }
            while (reader.readRecord()) {
                for (Attribute attribute : concept.getAttributes()) {
                    try {
                        if (attribute.getAcronym().equals("ID")) continue;
                        attribute_value /* !! */  = null;
                        if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                            multi_string = new MultilingualString();
                            for (String lang : MultilingualString.LANGUAGES) {
                                value = null;
                                if (metadata.useHeaders()) {
                                    header = metadata.getAttributeHeader(attribute.getAcronym(), lang);
                                    value = reader.get(header);
                                } else {
                                    column = metadata.getAttributeColumn(attribute.getAcronym(), lang);
                                    value = reader.get(column);
                                }
                                multi_string.setValue(lang, value);
                            }
                            attribute_value /* !! */  = multi_string;
                            continue;
                        }
                        value = null;
                        if (metadata.useHeaders()) {
                            header = metadata.getAttributeHeader(attribute.getAcronym());
                            value = reader.get(header);
                        } else {
                            column = metadata.getAttributeColumn(attribute.getAcronym());
                            value = reader.get(column);
                        }
                        if (value != null && value.length() > 0) {
                            block22: {
                                try {
                                    constructor = attribute.getType().getRuntimeType().getConstructor(new Class[]{String.class});
                                    attribute_value /* !! */  = constructor.newInstance(new Object[]{value});
                                    break block22;
                                }
                                catch (Exception e) {
                                    System.out.println("attr=" + attribute.getAcronym() + " ,type=" + attribute.getType().toString());
                                    classz2 = attribute.getType().getRuntimeType();
                                    System.out.println("getRuntimeType=" + classz2.getName());
                                    c = classz2.getConstructors();
                                    i = 0;
                                    ** while (i < c.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    System.out.println(String.valueOf(i) + "=" + c[i]);
                                    ++i;
                                    continue;
                                }
lbl57:
                                // 1 sources

                                throw new FSIOException("IO: Uncompatible type error found for attribute: " + attribute.getAcronym() + ", expected: " + attribute.getType().getRuntimeType() + ", found: " + value.getClass(), reader.getCurrentRecord() + 1L);
                            }
                            if (!attribute.isCodeAttribute()) continue;
                            values = (Set)code_attributes_values.get(attribute);
                            if (values.contains(attribute_value /* !! */ )) {
                                throw new FSIOException("Non unique value found for attribute: " + attribute.getAcronym() + ", found: " + value, reader.getCurrentRecord() + 1L);
                            }
                            values.add(attribute_value /* !! */ );
                            continue;
                        }
                        if (!attribute.isCodeAttribute()) continue;
                        throw new FSIOException("Null value found for attribute: " + attribute.getAcronym(), reader.getCurrentRecord() + 1L);
                    }
                    catch (FSIOException re) {
                        reporter.error(re.getCSVRowCount(), re.getPlainMessage());
                    }
                    catch (Exception e) {
                        reporter.fatal(reader.getCurrentRecord() + 1L, "Unexpected fatal error found validating CSV record: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            reporter.fatal("Unexpected fatal error found validating CSV file: " + e.getMessage());
        }
        return reporter.getResult();
    }

    public void upload(Relationship relationship, Reader input, ReferenceRelationshipCSVMetadata metadata, boolean truncate, ILog log) throws FSIOException {
        try {
            if (relationship == null) {
                throw new FSIOException("Relationship can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createRelationshipMetadata();
            }
            this._upload(relationship, input, metadata, truncate, log);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to load relationship", e);
        }
    }

    public ValidationResult validate(Relationship relationship, Reader input, ReferenceRelationshipCSVMetadata metadata, ILog log) {
        ValidationReporter reporter = new ValidationReporter();
        try {
            if (!(metadata.getParentAttribute() == null || metadata.getParentAttribute().equalsIgnoreCase("ID") || relationship.getParentConcept().getAttribute(metadata.getParentAttribute()) != null && relationship.getParentConcept().getAttribute(metadata.getParentAttribute()).isCodeAttribute())) {
                throw new FSIOException("Parent reference attribute is not a valid (code) attribute for the concept: " + metadata.getParentAttribute());
            }
            if (!(metadata.getChildAttribute() == null || metadata.getChildAttribute().equalsIgnoreCase("ID") || relationship.getChildConcept().getAttribute(metadata.getChildAttribute()) != null && relationship.getChildConcept().getAttribute(metadata.getChildAttribute()).isCodeAttribute())) {
                throw new FSIOException("Child reference attribute is not a valid (code) attribute for the concept: " + metadata.getChildAttribute());
            }
            CsvReader reader = new CsvReader(input, ',');
            this.checkHeaders(relationship, reader, metadata);
            HashMap groups = new HashMap();
            while (reader.readRecord()) {
                try {
                    Constructor constructor;
                    String value = null;
                    value = metadata.useHeaders() ? reader.get(metadata.getParentHeader()) : reader.get(metadata.getParentColumn());
                    if (value == null) {
                        throw new FSIOException("Invalid null parent object found", reader.getCurrentRecord() + 1L);
                    }
                    ReferenceObject parent = null;
                    String reference_attribute = metadata.getParentAttribute();
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierFactory.instance((String)value);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Unexpected parent object identifier, found: " + value, reader.getCurrentRecord() + 1L);
                        }
                        parent = relationship.getParentConcept().getObject(id);
                        if (parent == null) {
                            throw new FSIOException("No matching parent reference object found for : " + reference_attribute + "=" + id + ", concept=" + relationship.getParentConcept(), reader.getCurrentRecord() + 1L);
                        }
                    } else {
                        Object attribute_value = null;
                        try {
                            Attribute attribute = relationship.getParentConcept().getAttribute(reference_attribute);
                            try {
                                constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                                attribute_value = constructor.newInstance(value);
                            }
                            catch (Exception e) {
                                System.out.println("attr=" + attribute.getAcronym() + " ,type=" + attribute.getType().toString() + " ,jdbc=" + attribute.getType().getJdbcType());
                                throw new FSIOException("IO: Uncompatible type error found for attribute: " + attribute.getAcronym() + ", expected: " + attribute.getType().getRuntimeType() + ", found: " + value.getClass(), reader.getCurrentRecord() + 1L);
                            }
                            parent = relationship.getParentConcept().getObject(reference_attribute, attribute_value);
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get parent reference object: " + relationship.getParentConcept().getAcronym() + ", " + reference_attribute + "=" + value + ", error: " + e.getMessage(), e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (parent == null) {
                        throw new FSIOException("No matching parent reference object found for : " + reference_attribute + "=" + value, reader.getCurrentRecord() + 1L);
                    }
                    HashSet<ReferenceObject> children = (HashSet<ReferenceObject>)groups.get(parent);
                    if (children == null) {
                        children = new HashSet<ReferenceObject>();
                    }
                    value = null;
                    value = metadata.useHeaders() ? reader.get(metadata.getChildHeader()) : reader.get(metadata.getChildColumn());
                    if (value == null) {
                        throw new FSIOException("Invalid null child object found", reader.getCurrentRecord() + 1L);
                    }
                    ReferenceObject child = null;
                    reference_attribute = metadata.getChildAttribute();
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierFactory.instance((String)value);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Unexpected child object identifier, found: " + value, reader.getCurrentRecord() + 1L);
                        }
                        child = relationship.getParentConcept().getObject(id);
                    } else {
                        try {
                            constructor = relationship.getChildConcept().getAttribute(reference_attribute).getType().getRuntimeType().getConstructor(String.class);
                            Object attribute_value = constructor.newInstance(value);
                            child = relationship.getChildConcept().getObject(reference_attribute, attribute_value);
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get child reference object: " + relationship.getChildConcept().getAcronym() + ", " + reference_attribute + "=" + value + ", error: " + e.getMessage(), e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (child == null) {
                        log.log((IStatus)new Status(4, "ReferenceCSVService.validate", "No matching child reference object found for : " + reference_attribute + "=" + value));
                    } else {
                        children.add(child);
                    }
                    groups.put(parent, children);
                }
                catch (FSIOException re) {
                    reporter.error(re.getCSVRowCount(), re.getPlainMessage());
                }
                catch (Exception e) {
                    reporter.fatal(reader.getCurrentRecord() + 1L, "Unexpected fatal error found validating CSV record: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            reporter.fatal("Unexpected fatal error found validating CSV file: " + e.getMessage());
        }
        return reporter.getResult();
    }

    private void _upload(Relationship relationship, Reader input, ReferenceRelationshipCSVMetadata metadata, boolean truncate, ILog log) throws Exception {
        CsvReader reader = new CsvReader(input, ',');
        if (metadata.useHeaders()) {
            reader.readHeaders();
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        if (truncate) {
            relationship.removeAll();
        }
        HashMap groups = new HashMap();
        while (reader.readRecord()) {
            System.out.println("loading record " + reader.getCurrentRecord());
            String value = null;
            if (metadata.useHeaders()) {
                String header = metadata.getParentHeader();
                value = reader.get(header);
            } else {
                int column = metadata.getParentColumn();
                value = reader.get(column);
            }
            if (value == null) {
                throw new FSIOException("Unable to read parent object CSV reference", reader.getCurrentRecord() + 1L + 1L);
            }
            ReferenceObject parent = null;
            String reference_attribute = metadata.getParentAttribute();
            if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                Identifier id = null;
                try {
                    id = IdentifierFactory.instance((String)value);
                }
                catch (Exception e) {
                    throw new FSIOException("Key value is not an identifier: " + value, e, reader.getCurrentRecord() + 1L + 1L);
                }
                parent = relationship.getParentConcept().getObject(id);
            } else {
                try {
                    Constructor constructor = relationship.getParentConcept().getAttribute(reference_attribute).getType().getRuntimeType().getConstructor(String.class);
                    Object attribute_value = constructor.newInstance(value);
                    parent = relationship.getParentConcept().getObject(reference_attribute, attribute_value);
                }
                catch (ReferenceServiceException e) {
                    throw new FSIOException("Unable to get parent reference object: " + relationship.getParentConcept().getAcronym() + ", " + reference_attribute + "=" + value, e, reader.getCurrentRecord() + 1L + 1L);
                }
            }
            if (parent == null) {
                throw new FSIOException("No matching parent reference object found for : " + reference_attribute + "=" + value, reader.getCurrentRecord() + 1L + 1L);
            }
            HashSet<ReferenceObject> children = (HashSet<ReferenceObject>)groups.get(parent);
            if (children == null) {
                children = new HashSet<ReferenceObject>();
            }
            value = null;
            if (metadata.useHeaders()) {
                String header = metadata.getChildHeader();
                value = reader.get(header);
            } else {
                int column = metadata.getChildColumn();
                value = reader.get(column);
            }
            if (value == null) {
                throw new FSIOException("Unable to read child object CSV reference", reader.getCurrentRecord() + 1L + 1L);
            }
            ReferenceObject child = null;
            reference_attribute = metadata.getChildAttribute();
            if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                Identifier id = null;
                try {
                    id = IdentifierFactory.instance((String)value);
                }
                catch (Exception e) {
                    throw new FSIOException("Key value is not an identifier: " + value, e, reader.getCurrentRecord() + 1L + 1L);
                }
                child = relationship.getParentConcept().getObject(id);
            } else {
                try {
                    Constructor constructor = relationship.getChildConcept().getAttribute(reference_attribute).getType().getRuntimeType().getConstructor(String.class);
                    Object attribute_value = constructor.newInstance(value);
                    child = relationship.getChildConcept().getObject(reference_attribute, attribute_value);
                }
                catch (ReferenceServiceException e) {
                    throw new FSIOException("Unable to get child reference object: " + relationship.getChildConcept().getAcronym() + ", " + reference_attribute + "=" + value, e, reader.getCurrentRecord() + 1L + 1L);
                }
            }
            if (child == null) {
                log.log((IStatus)new Status(4, "ReferenceCSVService._upload", "No matching child reference object found for : " + reference_attribute + "=" + value));
            } else {
                children.add(child);
            }
            groups.put(parent, children);
        }
        System.out.println("persisting " + groups.size() + " groups");
        int index = 1;
        for (Map.Entry entry : groups.entrySet()) {
            System.out.println("persisting group " + index++);
            ReferenceObject parent = (ReferenceObject)entry.getKey();
            if (truncate) {
                relationship.setChildren(parent, (Set)entry.getValue());
                continue;
            }
            relationship.addChildren(parent, (Set)entry.getValue());
        }
        System.out.println("groups persisted");
    }

    public ReferenceConceptCSVMetadata createConceptMetadata(Concept concept) {
        return new ReferenceConceptCSVMetadataImpl(concept);
    }

    public ReferenceRelationshipCSVMetadata createRelationshipMetadata() {
        return new ReferenceRelationshipCSVMetadataImpl();
    }
}

