/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.junit.BeforeClass;
import org.junit.Test;

public class DownloadReferenceCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace((boolean)false);
    }

    @Test
    public void testDownloadRelContinentCountryCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("CONTINENT_COUNTRY");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("UN_CODE");
        metadata.setParentHeader("CONTINENT");
        metadata.setChildAttribute("UN_CODE");
        metadata.setChildHeader("COUNTRY");
        ReferenceCSVService.instance().download(relationship, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REL_" + relationship.getAcronym() + ".csv")), "UTF8"), metadata);
    }

    @Test
    public void testDownloadSpeciesCSV() throws Exception {
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        ReferenceCSVService.instance().download(species, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_SPECIES.csv")), "UTF8"), null);
        for (Concept concept : species.getRelatedConcepts()) {
            ReferenceCSVService.instance().download(concept, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_" + concept.getAcronym() + ".csv")), "UTF8"), null);
        }
        for (Relationship relationship : species.getRelationships()) {
            ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
            ReferenceCSVService.instance().download(relationship, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REL_" + relationship.getAcronym() + ".csv")), "UTF8"), metadata);
        }
    }

    @Test
    public void testDownloadAreaCSV() throws Exception {
        Concept area = ReferenceServiceFactory.getService().getConcept("AREA");
        ReferenceCSVService.instance().download(area, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_AREA.csv")), "UTF8"), null);
        for (Concept concept : area.getRelatedConcepts()) {
            ReferenceCSVService.instance().download(concept, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_" + concept.getAcronym() + ".csv")), "UTF8"), null);
        }
        for (Relationship relationship : area.getRelationships()) {
            ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
            ReferenceCSVService.instance().download(relationship, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REL_" + relationship.getAcronym() + ".csv")), "UTF8"), metadata);
        }
    }

    @Test
    public void testDownloadCountryCSV() throws Exception {
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        ReferenceCSVService.instance().download(country, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_COUNTRY.csv")), "UTF8"), null);
        for (Concept concept : country.getRelatedConcepts()) {
            ReferenceCSVService.instance().download(concept, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REF_" + concept.getAcronym() + ".csv")), "UTF8"), null);
        }
        for (Relationship relationship : country.getRelationships()) {
            ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
            ReferenceCSVService.instance().download(relationship, (Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(Commons.TMP_DIR) + "REL_" + relationship.getAcronym() + ".csv")), "UTF8"), metadata);
        }
    }
}

