/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceConceptCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.common.api.csv.ValidationResult;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReferenceCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testLoadTradeFlowCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("TRADE_FLOW");
        ValidationResult result = ReferenceCSVService.instance().validate(concept, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/trade/ref_trade_flow.csv"))), null, null);
        Assert.assertTrue((String)"Validation check failed", (boolean)result.isValid());
        if (result.isValid()) {
            ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/trade/ref_trade_flow.csv"))), null, true);
        } else {
            System.out.println(result.toString());
        }
    }

    @Test
    public void testLoadCommodityCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("COMMODITY");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setAttributeHeader("NAME_EN", "NAME_E");
        metadata.setAttributeHeader("NAME_FR", "NAME_F");
        metadata.setAttributeHeader("NAME_ES", "NAME_S");
        metadata.setAttributeHeader("FID", "CD_ITEM");
        ValidationResult result = ReferenceCSVService.instance().validate(concept, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/trade/ref_commodity_utf8.csv"))), null, null);
        Assert.assertTrue((String)"Validation check failed", (boolean)result.isValid());
        if (result.isValid()) {
            ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/trade/ref_commodity_utf8.csv"))), metadata, true);
        } else {
            System.out.println(result.toString());
        }
    }

    @Test
    public void testValidateMonthCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("MONTH");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ValidationResult result = ReferenceCSVService.instance().validate(concept, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_month_faulty.csv"))), metadata, null);
        Assert.assertFalse((String)"Validation check failed", (boolean)result.isValid());
        System.out.println(result.toString());
    }

    @Test
    public void testLoadVesselTypeCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("VESSEL_TYPE");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_type_all.csv"))), metadata, true);
    }

    @Test
    public void testLoadVesselTypeGroupCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("VESSEL_TYPE_GROUP");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_type_group.csv"))), metadata, true);
    }

    @Test
    public void testLoadVesselTypeRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("VESSEL_TYPE_GROUP_VESSEL_TYPE");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("ISSCFV_CODE");
        metadata.setChildAttribute("ISSCFV_CODE");
        metadata.setParentHeader("PARENT_ISSCFV_CODE");
        metadata.setChildHeader("ISSCFV_CODE");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_type_all.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadVesselClassCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("VESSEL_GRT_CLASS");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_class.csv"))), metadata, true);
    }

    @Test
    public void testLoadVesselClassGroupCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("VESSEL_GRT_CLASS_GROUP");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_class_group.csv"))), metadata, true);
    }

    @Test
    public void testLoadVesselClassRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("VESSEL_GRT_CLASS_GROUP_VESSEL_GRT_CLASS");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("ISSCFV_CODE");
        metadata.setChildAttribute("ISSCFV_CODE");
        metadata.setParentHeader("PARENT_ISSCFV_CODE");
        metadata.setChildHeader("ISSCFV_CODE");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/vessel/ref_vessel_class.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadGearTypeCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("GEAR_TYPE");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/gear/ref_geartype.csv"))), metadata, true);
    }

    @Test
    public void testLoadGearTypeGroupCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("GEAR_TYPE_GROUP");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/gear/ref_geartype_group.csv"))), metadata, true);
    }

    @Test
    public void testLoadGearTypeRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("GEAR_TYPE_GROUP_GEAR_TYPE");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("ISSCFG_CODE");
        metadata.setChildAttribute("ISSCFG_CODE");
        metadata.setParentHeader("PARENT_ISSCFG_CODE");
        metadata.setChildHeader("ISSCFG_CODE");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/gear/ref_geartype.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadMonthCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("MONTH");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_month.csv"))), metadata, true);
    }

    @Test
    public void testLoadQuarterCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("QUARTER");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setUseHeaders(true);
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_quarter.csv"))), metadata, true);
    }

    @Test
    public void testLoadQuarterMonthRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("QUARTER_MONTH");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("CODE");
        metadata.setChildAttribute("CODE");
        metadata.setParentHeader("PARENT_CODE");
        metadata.setChildHeader("CODE");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_month.csv"))), metadata, true, null);
    }
}

