/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceConceptCSVMetadata;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpeciesReferenceCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testLoadSpeciesCSV() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("SPECIES");
        ReferenceConceptCSVMetadata metadata = ReferenceCSVService.instance().createConceptMetadata(concept);
        metadata.setTextQualifier('\"');
        metadata.setAttributeHeader("NAME_EN", "FULL_NAME_E");
        metadata.setAttributeHeader("NAME_FR", "FULL_NAME_F");
        metadata.setAttributeHeader("NAME_ES", "FULL_NAME_S");
        metadata.setAttributeHeader("FID", "FIC_ITEM");
        metadata.setAttributeHeader("TAXONOMIC_CODE", "FIC_SYS_ITEM");
        metadata.setAttributeHeader("ALPHA_3_CODE", "ALPHA3CODE");
        ReferenceCSVService.instance().upload(concept, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/species/ref_species.csv"))), metadata, true);
    }
}

