/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MultilingualString
implements Serializable {
    private static final long serialVersionUID = 3622500520388545271L;
    public static final String EN = "en";
    public static final String FR = "fr";
    public static final String ES = "es";
    public static final String AR = "ar";
    public static final String ZH = "zh";
    public static final String RU = "ru";
    public static final List<String> LANGUAGES = Collections.unmodifiableList(Arrays.asList("en", "fr", "es", "ar", "zh", "ru"));
    public static final MultilingualString NAME = new MultilingualString((Map<String, String>)new HashMap<String, String>(){
        private static final long serialVersionUID = 3622500520388545271L;
        {
            this.put(MultilingualString.EN, "Name");
            this.put(MultilingualString.FR, "Nom");
            this.put(MultilingualString.ES, "Nombre");
        }
    });
    public static final MultilingualString DESCRIPTION = new MultilingualString((Map<String, String>)new HashMap<String, String>(){
        private static final long serialVersionUID = 3622500520388545271L;
        {
            this.put(MultilingualString.EN, "Description");
            this.put(MultilingualString.FR, "Description");
            this.put(MultilingualString.ES, "Descripci\u00f3n");
        }
    });
    private Map<String, String> values;

    public MultilingualString() {
        this.values = new HashMap<String, String>(LANGUAGES.size());
        for (String lang : LANGUAGES) {
            this.values.put(lang, null);
        }
    }

    public MultilingualString(MultilingualString other) {
        this.values = new HashMap<String, String>(LANGUAGES.size());
        for (String lang : LANGUAGES) {
            this.values.put(lang, other.getValue(lang));
        }
    }

    public MultilingualString(Map<String, String> values) {
        if (values == null) {
            throw new IllegalArgumentException("Invalid languages supplied");
        }
        this.values = new HashMap<String, String>(LANGUAGES.size());
        for (String lang : LANGUAGES) {
            this.values.put(lang, values.get(lang));
        }
    }

    public String getValue(String lang) {
        return this.values.get(lang);
    }

    public void setValue(String lang, String value) {
        this.values.put(lang, value);
    }

    public String getValue(Locale locale) {
        return this.values.get(locale.getLanguage());
    }

    public void setValue(Locale locale, String value) {
        this.values.put(locale.getLanguage(), value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String language : LANGUAGES) {
            buffer.append("[").append(language).append(":").append(this.getValue(language)).append("]");
        }
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultilingualString)) {
            return false;
        }
        MultilingualString other = (MultilingualString)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

