/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.fao.fi.fishstat.data.common.jdbc.JdbcDriverDescriptor;

public class JdbcDriverRegistry {
    public static final String DERBY_EMBEDDED_JDBC_DRIVER = "Apache Derby - embedded";
    public static final String DERBY_REMOTE_JDBC_DRIVER = "Apache Derby - remote";
    public static final String ORACLE_JDBC_DRIVER = "Oracle";
    public static final String POSTGREE_JDBC_DRIVER = "PostgreeSQL";
    private static HashMap<String, JdbcDriverDescriptor> registry = null;

    public static JdbcDriverDescriptor getDriverDescriptor(String id) {
        if (registry == null) {
            JdbcDriverRegistry.populateRegistry();
        }
        return registry.get(id);
    }

    public static Set<String> getDescriptorsIds() {
        if (registry == null) {
            JdbcDriverRegistry.populateRegistry();
        }
        return registry.keySet();
    }

    public static Collection<JdbcDriverDescriptor> getDescriptors() {
        if (registry == null) {
            JdbcDriverRegistry.populateRegistry();
        }
        return registry.values();
    }

    private static void populateRegistry() {
        registry = new LinkedHashMap<String, JdbcDriverDescriptor>(5);
        JdbcDriverRegistry.addDescriptor(new JdbcDriverDescriptor(DERBY_EMBEDDED_JDBC_DRIVER, "org.apache.derby.jdbc.EmbeddedDriver"));
        JdbcDriverRegistry.addDescriptor(new JdbcDriverDescriptor(DERBY_REMOTE_JDBC_DRIVER, "org.apache.derby.jdbc.ClientDriver"));
        JdbcDriverRegistry.addDescriptor(new JdbcDriverDescriptor(ORACLE_JDBC_DRIVER, "oracle.jdbc.driver.OracleDriver"));
        JdbcDriverRegistry.addDescriptor(new JdbcDriverDescriptor(POSTGREE_JDBC_DRIVER, "org.postgresql.Driver"));
    }

    private static void addDescriptor(JdbcDriverDescriptor descriptor) {
        registry.put(descriptor.getId(), descriptor);
    }
}

