/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.register;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;

public class StructuralChangeEventListenerRegistry {
    private Set<StructuralChangeEvent> events = Collections.synchronizedSet(new HashSet());
    private Map<StructuralChangeEvent, Collection<WeakReference<StructuralChangeEventListener>>> register = Collections.synchronizedMap(new HashMap());

    public void registerListener(StructuralChangeEvent change, StructuralChangeEventListener listener) {
        if (this.register.get(change) == null) {
            this.register.put(change, Collections.synchronizedCollection(new ArrayList()));
        }
        this.register.get(change).add(new WeakReference<StructuralChangeEventListener>(listener));
    }

    public void removeListener(StructuralChangeEvent change, StructuralChangeEventListener listener) {
        if (this.register.get(change) != null) {
            this.register.get(change).remove(listener);
        }
    }

    public void removeListener(StructuralChangeEventListener listener) {
        for (Collection<WeakReference<StructuralChangeEventListener>> listeners : this.register.values()) {
            listeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        for (Collection<WeakReference<StructuralChangeEventListener>> listeners : this.register.values()) {
            listeners.clear();
        }
    }

    public void fireRegisteredStructuralChangeEvents() {
        for (StructuralChangeEvent change : this.events) {
            this.fireStructuralChangeEvent(change);
        }
        this.events.clear();
    }

    public void fireStructuralChangeEvent(StructuralChangeEvent change) {
        if (this.register.get(change) != null) {
            for (WeakReference<StructuralChangeEventListener> object : this.register.get(change)) {
                StructuralChangeEventListener listener = (StructuralChangeEventListener)object.get();
                if (listener == null) continue;
                listener.onStructuralChangeEvent(change);
            }
        }
    }

    public void registerStructuralChangeEvent(StructuralChangeEvent change) {
        this.events.add(change);
    }

    public void fireAndRegisterStructuralChangeEvent(StructuralChangeEvent change) {
        this.fireStructuralChangeEvent(change);
        this.registerStructuralChangeEvent(change);
    }
}

