/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.export.impl;

import java.util.List;
import org.fao.fi.fishstat.export.ExportDataItem;
import org.fao.fi.fishstat.export.StructuredDataItem;

public class ExportDataItemImpl<T>
implements ExportDataItem<T>,
Cloneable {
    private StructuredDataItem<String, String> keysData;
    private StructuredDataItem<T, String> measData;
    private StructuredDataItem<T, String> calcData;

    public ExportDataItemImpl(StructuredDataItem<String, String> keysData, StructuredDataItem<T, String> measData, StructuredDataItem<T, String> calcData) {
        this.keysData = keysData;
        this.measData = measData;
        this.calcData = calcData;
    }

    @Override
    public StructuredDataItem<String, String> getKeysData() {
        return this.keysData;
    }

    @Override
    public StructuredDataItem<T, String> getMeasData() {
        return this.measData;
    }

    @Override
    public StructuredDataItem<T, String> getCalcData() {
        return this.calcData;
    }

    private String keyDataToString() {
        List<String> values = this.getKeysData().getValues();
        List<String> attributes = this.getKeysData().getAttributes();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < values.size()) {
            String values_row = values.get(i);
            buffer.append(values_row).append("\t\t\t");
            if (attributes != null) {
                String attributes_row = attributes.get(i);
                buffer.append("[");
                buffer.append(attributes_row);
                buffer.append("]\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String measureDataToString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        int i = 0;
        while (i < this.getMeasData().getValues().size()) {
            T value = this.getMeasData().getValues().get(i);
            String attribute = this.getMeasData().getAttributes().get(i);
            buffer.append(value).append("[").append(attribute).append("]").append("\t\t");
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private String calcDataToString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        int i = 0;
        while (i < this.getCalcData().getValues().size()) {
            T value = this.getCalcData().getValues().get(i);
            String attribute = this.getCalcData().getAttributes().get(i);
            buffer.append(value).append("[").append(attribute).append("]").append("\t\t");
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return "KEYS\n" + this.keyDataToString() + "MEASURES\n" + this.measureDataToString() + "CALC.COLUMNS\n" + this.calcDataToString();
    }

    @Override
    public ExportDataItemImpl<T> clone() {
        return new ExportDataItemImpl<T>((StructuredDataItem<String, String>)this.keysData.clone(), this.measData.clone(), this.calcData.clone());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExportDataItem) {
            ExportDataItem exportDataItem = (ExportDataItem)obj;
            return this.keysData.equals(exportDataItem.getKeysData()) && this.measData.equals(exportDataItem.getMeasData()) && this.calcData.equals(exportDataItem.getCalcData());
        }
        return false;
    }
}

