/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class MultiSortProperties
extends Observable
implements IFSActions {
    public static final int MAX_NUM_SORTERS = 5;
    private TimeSeriesProperties timeSeriesProperties;
    private String uid;
    private List<MultiSortElemProperties> sorters;

    private MultiSortProperties() {
    }

    public MultiSortProperties(TimeSeriesProperties p, String acronym) {
        this.timeSeriesProperties = p;
        this.uid = this.calcUid(acronym);
        if (this.timeSeriesProperties.getPreferenceStore().getString(this.uid).length() > 0) {
            this.loadProperties();
        } else {
            this.createDefaultSorter();
        }
    }

    public String getUid() {
        return this.uid;
    }

    public List<MultiSortElemProperties> getColumnSorters() {
        return this.sorters;
    }

    public TimeSeriesProperties getTimeSeriesProperties() {
        return this.timeSeriesProperties;
    }

    public void setProperties(TimeSeriesProperties properties) {
        this.timeSeriesProperties = properties;
    }

    public void createDefaultSorter() {
        try {
            List dimensions = this.timeSeriesProperties.getDatasetProperties().getDataset().getDimensions();
            this.sorters = new Vector<MultiSortElemProperties>(dimensions.size());
            int i = 0;
            while (i < dimensions.size()) {
                this.sorters.add(new MultiSortElemProperties(this, (Dimension)dimensions.get(i)));
                ++i;
            }
        }
        catch (TimeseriesServiceException e) {
            throw new Error(e);
        }
    }

    public MultiSortElemProperties getSorter(int index) {
        if (index < this.sorters.size()) {
            return this.sorters.get(index);
        }
        return null;
    }

    public int size() {
        return this.sorters.size();
    }

    public void addNewSorter(boolean notify) {
        if (this.sorters.size() < 5) {
            try {
                this.sorters.add(new MultiSortElemProperties(this, (Dimension)this.timeSeriesProperties.getDataset().getDimensions().get(0)));
            }
            catch (TimeseriesServiceException e) {
                e.printStackTrace();
            }
        }
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public Dataset getDataset() {
        return this.timeSeriesProperties.getDataset();
    }

    public Timeseries getTimeseries() {
        return this.timeSeriesProperties.getTimeseries();
    }

    public void removeSorter(int idx, boolean notify) {
        this.sorters.remove(idx);
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void removeLastSorter(boolean notify) {
        this.sorters.remove(this.sorters.size() - 1);
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void removeSorter(MultiSortElemProperties s, boolean notify) {
        this.sorters.remove(s);
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void moveSorterUp(MultiSortElemProperties s, boolean notify) {
        int i = this.sorters.indexOf(s);
        if (i > 0) {
            this.sorters.remove(s);
            this.sorters.add(i - 1, s);
        }
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void moveSorterDown(MultiSortElemProperties s, boolean notify) {
        int i = this.sorters.indexOf(s);
        if (i < this.sorters.size() - 1) {
            this.sorters.remove(s);
            this.sorters.add(i + 1, s);
        }
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    @Override
    protected void setChanged() {
        this.timeSeriesProperties.getDatasetProperties().addAction(41);
        super.setChanged();
    }

    private String calcUid(String id) {
        return "timeseries." + this.timeSeriesProperties.getTimeseries().getAcronym() + ".sorter." + id;
    }

    protected void loadProperties() {
        String message = this.timeSeriesProperties.getPreferenceStore().getString(this.uid);
        String[] parts = message.split(";");
        this.sorters = new Vector<MultiSortElemProperties>(parts.length);
        int i = 0;
        while (i < parts.length) {
            MultiSortElemProperties sorter = new MultiSortElemProperties(this);
            sorter.unmarshal(parts[i]);
            this.sorters.add(sorter);
            ++i;
        }
    }

    public void storeProperties() {
        StringBuffer message = new StringBuffer();
        for (MultiSortElemProperties sorter : this.sorters) {
            if (!sorter.isActive()) continue;
            message.append(String.valueOf(sorter.marshal()) + ";");
        }
        message.trimToSize();
        message.deleteCharAt(message.length() - 1);
        this.timeSeriesProperties.getPreferenceStore().setValue(this.uid, message.toString());
        try {
            this.timeSeriesProperties.getPreferenceStore().save();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected MultiSortProperties replicateProperties(TimeSeriesProperties timeSeriesProperties) {
        MultiSortProperties res = new MultiSortProperties();
        res.timeSeriesProperties = timeSeriesProperties;
        res.uid = res.calcUid("DEFAULT");
        res.sorters = new LinkedList<MultiSortElemProperties>();
        for (MultiSortElemProperties multiSortElemProperties : this.sorters) {
            res.sorters.add(multiSortElemProperties.clone());
        }
        return res;
    }
}

