/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesAttributeProperties;

public class TimeSeriesProperties
implements IFSActions {
    protected String id;
    protected DatasetProperties datasetProperties;
    protected Timeseries timeseries;
    protected Integer firstYear;
    protected Integer lastYear;
    protected Integer firstQuarter;
    protected Integer lastQuarter;
    protected Integer firstMonth;
    protected Integer lastMonth;
    protected Integer basicMultiplier;
    protected Vector<TimeSeriesAttributeProperties> attributes;
    protected CalculatedMeasuresProperties calculatedMesaureProperties;
    protected List<ObservationPeriod> periods;
    private MultiSortProperties sorterProperties;

    public TimeSeriesProperties(Timeseries t, DatasetProperties d) {
        this.timeseries = t;
        this.datasetProperties = d;
        this.loadAttributes(this.timeseries);
        this.calculatedMesaureProperties = new CalculatedMeasuresProperties(this);
        this.id = "timeseries." + this.timeseries.getAcronym();
        this.allocatePeriods();
        this.createDefaultSorter();
    }

    public Integer getFirstYear() {
        return this.firstYear;
    }

    public Integer getLastYear() {
        return this.lastYear;
    }

    public Integer getFirstQuarter() {
        return this.firstQuarter;
    }

    public Integer getLastQuarter() {
        return this.lastQuarter;
    }

    public Integer getFirstMonth() {
        return this.firstMonth;
    }

    public Integer getLastMonth() {
        return this.lastMonth;
    }

    public void setLastYear(Integer lastYear) {
        this.lastYear = lastYear;
    }

    public List<ObservationPeriod> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<ObservationPeriod> periods) {
        this.periods = periods;
        this.datasetProperties.addAction(22, 92, 33, 93);
        this.datasetProperties.setChanged();
    }

    public int getPeriodsSize() {
        return this.periods.size();
    }

    public int getAttributesSize() {
        return this.attributes.size();
    }

    public Vector<TimeSeriesAttributeProperties> getAttributes() {
        return this.attributes;
    }

    public TimeSeriesAttributeProperties getAttribute(int idx) {
        return this.attributes.get(idx);
    }

    public ObservationPeriod getPeriod(int index) {
        return this.periods.get(index);
    }

    public boolean hasPeriod(int index) {
        return this.periods != null && this.periods.size() > index;
    }

    public Dataset getDataset() {
        return this.datasetProperties.getDataset();
    }

    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    public void setTimeseries(Timeseries timeseries) {
        this.timeseries = timeseries;
    }

    public DatasetProperties getDatasetProperties() {
        return this.datasetProperties;
    }

    public PreferenceStore getPreferenceStore() {
        return this.datasetProperties.getPreferenceStore();
    }

    public MultiSortProperties getSorter() {
        if (this.sorterProperties == null) {
            this.createDefaultSorter();
        }
        return this.sorterProperties;
    }

    public void setSorter(MultiSortProperties sorter) {
        this.sorterProperties = sorter;
    }

    private void createDefaultSorter() {
        this.sorterProperties = new MultiSortProperties(this, "DEFAULT");
    }

    private void allocatePeriods() {
        this.periods = new LinkedList<ObservationPeriod>(this.timeseries.getObservationPeriods());
        if (this.timeseries.getTimeResolution().equals((Object)TimeResolution.YEAR)) {
            this.basicMultiplier = 1;
            this.firstYear = new Integer(this.timeseries.getFirstObservationPeriod().getISO8601());
            this.lastYear = new Integer(this.timeseries.getLastObservationPeriod().getISO8601());
        }
        if (this.timeseries.getTimeResolution().equals((Object)TimeResolution.QUARTER)) {
            this.basicMultiplier = 3;
            this.firstYear = new Integer(this.timeseries.getFirstObservationPeriod().getYear());
            this.lastYear = new Integer(this.timeseries.getLastObservationPeriod().getYear());
            this.firstQuarter = new Integer(this.timeseries.getFirstObservationPeriod().getQuarter());
            this.lastQuarter = new Integer(this.timeseries.getLastObservationPeriod().getQuarter());
        }
        if (this.timeseries.getTimeResolution().equals((Object)TimeResolution.MONTH)) {
            this.basicMultiplier = 12;
            this.firstYear = new Integer(this.timeseries.getFirstObservationPeriod().getYear());
            this.lastYear = new Integer(this.timeseries.getLastObservationPeriod().getYear());
            this.firstMonth = new Integer(this.timeseries.getFirstObservationPeriod().getMonth());
            this.lastMonth = new Integer(this.timeseries.getLastObservationPeriod().getMonth());
        }
    }

    private void loadAttributes(Timeseries ts) {
        this.attributes = new Vector(ts.getAttributes().size());
        for (Map.Entry entry : ts.getAttributes().entrySet()) {
            TimeSeriesAttributeProperties attprop = new TimeSeriesAttributeProperties(this, (Attribute)entry.getKey());
            this.attributes.add(attprop);
        }
    }

    public CalculatedMeasuresProperties getCalculatedMesaureProperties() {
        return this.calculatedMesaureProperties;
    }

    public boolean hasCalculatedMesaureProperties() {
        return this.calculatedMesaureProperties != null && this.calculatedMesaureProperties.size() > 0;
    }

    protected void createDefaults(PreferenceStore store) {
        store.setDefault(String.valueOf(this.id) + ".unitcolumn", "true");
    }

    protected void loadProperties(PreferenceStore store) {
        String csv = store.getString(String.valueOf(this.id) + ".periods");
        if (csv != null && !csv.equals("")) {
            ObservationPeriod[] perArray = (ObservationPeriod[])CoreUtils.fromCsv((String)csv, ObservationPeriod.class);
            this.periods = Arrays.asList(perArray);
        }
        this.calculatedMesaureProperties.loadMeasureProperties(store);
    }

    protected void storeProperties() {
        PreferenceStore store = this.datasetProperties.getPreferenceStore();
        store.setValue(String.valueOf(this.id) + ".periods", CoreUtils.toCsv(this.periods));
        this.calculatedMesaureProperties.saveMeasureProperties(store);
        this.sorterProperties.storeProperties();
    }
}

