/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.topothers;

import java.beans.Beans;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.gui.core.session.GuiSession;

public class MeasuresComboViewer
extends Composite {
    private int style = 0;
    private Combo combo;
    private ComboViewer comboViewer;
    private GuiSession session;

    public MeasuresComboViewer(Composite parent, int style, GuiSession session) {
        super(parent, style);
        this.session = session;
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.comboViewer = new ComboViewer((Composite)this, this.style);
        this.combo = this.comboViewer.getCombo();
        this.combo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (!Beans.isDesignTime()) {
            this.comboViewer.setContentProvider((IContentProvider)new TopMeasuresContentProvider());
            this.comboViewer.setLabelProvider((IBaseLabelProvider)new TopMeasuresLabelProvider(this.session.getTimeseries().getTimeResolution()));
            this.comboViewer.setComparator((ViewerComparator)new TopMeasuresComparator());
            this.comboViewer.setInput((Object)this.session);
            this.comboViewer.setSelection((ISelection)new StructuredSelection(this.comboViewer.getElementAt(0)));
        }
    }

    protected void checkSubclass() {
    }

    public ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    public ISelection getSelection() {
        return this.comboViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.comboViewer.setSelection(selection);
    }

    public class TopMeasuresComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object c1, Object c2) {
            if (c1 instanceof ObservationPeriod && c2 instanceof CalculatedMeasureDefinition) {
                return -1;
            }
            if (c1 instanceof CalculatedMeasureDefinition && c2 instanceof ObservationPeriod) {
                return 1;
            }
            if (c1 instanceof ObservationPeriod && c2 instanceof ObservationPeriod) {
                return super.compare(viewer, c1, c2);
            }
            return c1.toString().compareToIgnoreCase(c2.toString());
        }
    }

    public class TopMeasuresContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Session) {
                LinkedList res = new LinkedList();
                GuiSession session = (GuiSession)inputElement;
                res.addAll(session.getTimeseriesProperties().getPeriods());
                Collection cmdColl = session.getTimeseries().getCalculatedMeasureDefinitions();
                res.addAll(cmdColl);
                return res.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TopMeasuresLabelProvider
    implements ILabelProvider {
        TimeResolution timeResolution = null;

        public TopMeasuresLabelProvider(TimeResolution timeResolution) {
            this.timeResolution = timeResolution;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ObservationPeriod) {
                return ((ObservationPeriod)element).getISO8601();
            }
            if (element instanceof CalculatedMeasureDefinition) {
                return ((CalculatedMeasureDefinition)element).getName();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "#ERROR#";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

