/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.topothers;

import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.topothers.TopOtherComposite;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class TopOtherDialog
extends TitleAreaDialog
implements IFSActions,
IGuiPreferencesConstants {
    private Session session;
    private TopCriteriaWrapper topCriteriaWrapper;
    private TopOtherComposite topOtherComposite;
    private CoreRegistry registry = GuiCoreActivator.getDefault().getRegistry();
    private boolean sameForRelatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");

    public TopOtherDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        Composite area = (Composite)super.createDialogArea(parent);
        area.setBackground(SWTResourceManager.getColor(1));
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(1808));
        if (Beans.isDesignTime()) {
            new TopOtherComposite(container, 0);
        } else {
            this.session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            this.topCriteriaWrapper = this.session.hasTopCriteriaRequest() ? this.session.getTopOthersRequest() : new TopCriteriaWrapper(this.session);
            this.topOtherComposite = new TopOtherComposite(container, 0, this.topCriteriaWrapper);
            this.setTitle(Activator.getLocalString("timeseries.topothers.dialog.title"));
            this.setMessage(Activator.getLocalString("timeseries.topothers.dialog.subtitle"));
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(Activator.getImage("icons/actions/topother.png"));
        newShell.setText(Activator.getLocalString("timeseries.topothers.dialog.bartitle"));
    }

    protected Point getInitialSize() {
        return new Point(400, 330);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.topOtherComposite.applyData(this.topCriteriaWrapper);
            if (this.topCriteriaWrapper.isUnvalorized()) {
                try {
                    this.removeTopOther();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.modifyTopOther();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    private void modifyTopOther() throws Exception {
        PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TopOtherDialog.this.registry.processActionRequest((IActionRequestWrapper)TopOtherDialog.this.topCriteriaWrapper, TopOtherDialog.this.sameForRelatives, monitor);
            }
        });
    }

    private void removeTopOther() throws Exception {
        PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TopOtherDialog.this.registry.removeActionRequest(4, TopOtherDialog.this.sameForRelatives, monitor);
            }
        });
    }
}

