/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.edit;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.export.CsvViewExporter;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettingsDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class SeriesCopyHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.edit.csv.copy.details";
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExportSettingsDialog dialog;
        int result;
        MultiTableView currentView = (MultiTableView)ApplicationWorkbenchAdvisor.getApplicationAdvisor().getLastActiveDoubleTableView();
        ExportSettings exportSettings = new ExportSettings(this.ps);
        if (this.ps.getBoolean("export.csv.askconfirm") && (result = (dialog = new ExportSettingsDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell(), exportSettings)).open()) == 1) {
            return null;
        }
        CsvViewExporter exporter = new CsvViewExporter(currentView, exportSettings);
        exporter.setSeparator(Character.valueOf('\t'));
        exporter.setWriter(new StringWriter());
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)exporter);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents(new Object[]{((StringWriter)exporter.getWriter()).getBuffer().toString()}, new Transfer[]{textTransfer});
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Export done", (String)(String.valueOf(Integer.toString(exporter.getExportSize())) + " rows have been copied to the clipboard"));
        exporter.close();
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() >= 1);
    }
}

