/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.dataexport;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.preferences.dataexport.DataExportPreferencesPanel;

public class CsvAndClipboardDataExport
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
    private DataExportPreferencesPanel preferencesPanel;
    private ExportSettings exportSettings;
    private Button btnCheckButton;

    public CsvAndClipboardDataExport() {
        this.setTitle(Activator.getLocalString("preferences.data.export.csv.format.title"));
        this.setMessage(Activator.getLocalString("preferences.data.export.csv.format.title"));
    }

    public Control createContents(Composite parent) {
        this.exportSettings = new ExportSettings(this.ps);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createPanel(container);
        this.syncroPanel();
        return container;
    }

    private void createPanel(Composite container) {
        Group grpExportPreferences = new Group(container, 0);
        grpExportPreferences.setBackgroundMode(2);
        grpExportPreferences.setText("Export preferences");
        grpExportPreferences.setLayout((Layout)new FillLayout(256));
        GridData gd_grpExportPreferences = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_grpExportPreferences.heightHint = 232;
        gd_grpExportPreferences.widthHint = 200;
        grpExportPreferences.setLayoutData((Object)gd_grpExportPreferences);
        this.preferencesPanel = new DataExportPreferencesPanel((Composite)grpExportPreferences, 0, this.exportSettings);
        this.btnCheckButton = new Button(container, 32);
        this.btnCheckButton.setText("Re-adjust the preferences on each export");
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.preferencesPanel.applyData();
        this.ps.setValue("export.csv.exportheaders", this.exportSettings.isExportHeaders());
        this.ps.setValue("export.csv.splitcolumns", this.exportSettings.isSplitSymbols());
        this.ps.setValue("export.csv.symbheaders", this.exportSettings.getSymbolHeader());
        this.ps.setValue("export.csv.nosymbols", this.exportSettings.isNoSymbols());
        this.ps.setValue("export.csv.exporttotals", this.exportSettings.isExportTotals());
        this.ps.setValue("export.csv.askconfirm", this.btnCheckButton.getSelection());
        this.ps.setValue("export.csv.exportcitation", this.exportSettings.isExportCitation());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.exportSettings.setExportHeaders(this.ps.getDefaultBoolean("export.csv.exportheaders"));
        this.exportSettings.setSplitSymbols(this.ps.getDefaultBoolean("export.csv.splitcolumns"));
        this.exportSettings.setSymbolHeader(this.ps.getDefaultString("export.csv.symbheaders"));
        this.exportSettings.setNoSymbols(this.ps.getDefaultBoolean("export.csv.nosymbols"));
        this.exportSettings.setExportTotals(this.ps.getDefaultBoolean("export.csv.exporttotals"));
        this.exportSettings.setExportCitation(this.ps.getDefaultBoolean("export.csv.exportcitation"));
        this.preferencesPanel.syncroPanel();
        this.btnCheckButton.setSelection(this.ps.getBoolean("export.csv.askconfirm"));
    }

    protected void syncroPanel() {
        this.preferencesPanel.syncroPanel();
        this.btnCheckButton.setSelection(this.ps.getBoolean("export.csv.askconfirm"));
    }
}

