/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.dataexport;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;

public class DataExportPreferencesPanel
extends Composite {
    private ExportSettings exportSettings;
    private Button btnHeadersExport;
    private Button btnSplitInTwoColumns;
    private Button btnDontExportSysmbols;
    private Button btnExportTotals;
    private Text txtSymbolColumnHeader;
    private Label lblSymbolColumnHeader;
    private Button btnExportCitation;

    public DataExportPreferencesPanel(Composite parent, int style, ExportSettings exportSettings) {
        super(parent, style);
        this.exportSettings = exportSettings;
        this.createPanel();
        this.syncroPanel();
    }

    private void createPanel() {
        this.btnHeadersExport = new Button((Composite)this, 32);
        this.btnHeadersExport.setBounds(10, 10, 215, 16);
        this.btnHeadersExport.setText("Export tables headers");
        this.btnSplitInTwoColumns = new Button((Composite)this, 32);
        this.btnSplitInTwoColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataExportPreferencesPanel.this.btnDontExportSysmbols.setEnabled(!DataExportPreferencesPanel.this.btnSplitInTwoColumns.getSelection());
                DataExportPreferencesPanel.this.txtSymbolColumnHeader.setEnabled(DataExportPreferencesPanel.this.btnSplitInTwoColumns.getSelection());
                DataExportPreferencesPanel.this.lblSymbolColumnHeader.setEnabled(DataExportPreferencesPanel.this.btnSplitInTwoColumns.getSelection());
            }
        });
        this.btnSplitInTwoColumns.setBounds(10, 32, 232, 16);
        this.btnSplitInTwoColumns.setText("Split values and symbols in two columns");
        this.btnDontExportSysmbols = new Button((Composite)this, 32);
        this.btnDontExportSysmbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataExportPreferencesPanel.this.btnSplitInTwoColumns.setEnabled(!DataExportPreferencesPanel.this.btnDontExportSysmbols.getSelection());
            }
        });
        this.btnDontExportSysmbols.setBounds(10, 76, 192, 16);
        this.btnDontExportSysmbols.setText("Don't export symbols");
        this.btnExportTotals = new Button((Composite)this, 32);
        this.btnExportTotals.setBounds(10, 98, 235, 16);
        this.btnExportTotals.setText("Export with totals on selected rows");
        this.txtSymbolColumnHeader = new Text((Composite)this, 2048);
        this.txtSymbolColumnHeader.setFont(SWTResourceManager.getFont("Tahoma", 7, 0));
        this.txtSymbolColumnHeader.setEnabled(false);
        this.txtSymbolColumnHeader.setBounds(184, 54, 41, 16);
        this.lblSymbolColumnHeader = new Label((Composite)this, 0);
        this.lblSymbolColumnHeader.setEnabled(false);
        this.lblSymbolColumnHeader.setBounds(43, 54, 148, 13);
        this.lblSymbolColumnHeader.setText("Header of the symbol column");
        this.btnExportCitation = new Button((Composite)this, 32);
        this.btnExportCitation.setBounds(10, 120, 101, 16);
        this.btnExportCitation.setText("Export citation");
    }

    public void applyData() {
        this.exportSettings.setExportHeaders(this.btnHeadersExport.getSelection());
        this.exportSettings.setSplitSymbols(this.btnSplitInTwoColumns.getSelection());
        this.exportSettings.setSymbolHeader(this.txtSymbolColumnHeader.getText());
        this.exportSettings.setNoSymbols(this.btnDontExportSysmbols.getSelection());
        this.exportSettings.setExportTotals(this.btnExportTotals.getSelection());
        this.exportSettings.setExportCitation(this.btnExportCitation.getSelection());
    }

    protected void syncroPanel() {
        this.btnHeadersExport.setSelection(this.exportSettings.isExportHeaders());
        this.btnSplitInTwoColumns.setSelection(this.exportSettings.isSplitSymbols());
        this.btnDontExportSysmbols.setEnabled(!this.btnSplitInTwoColumns.getSelection());
        this.txtSymbolColumnHeader.setEnabled(this.btnSplitInTwoColumns.getSelection());
        this.lblSymbolColumnHeader.setEnabled(this.btnSplitInTwoColumns.getSelection());
        this.txtSymbolColumnHeader.setText(this.exportSettings.getSymbolHeader() != null ? this.exportSettings.getSymbolHeader() : "");
        this.btnDontExportSysmbols.setSelection(this.exportSettings.isNoSymbols());
        this.btnSplitInTwoColumns.setEnabled(!this.btnDontExportSysmbols.getSelection());
        this.btnExportTotals.setSelection(this.exportSettings.isExportTotals());
        this.btnExportCitation.setSelection(this.exportSettings.isExportCitation());
    }

    public ExportSettings getExportSettings() {
        return this.exportSettings;
    }
}

