/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class ConceptNameDescriptorTableViewer
extends TableViewer
implements Observer {
    private static final String CONCEPT = "Concept";
    private static final String NAME = "Name";
    private static final String DESCRIPTION = "Description";
    private static final String[] PROPERTIES = new String[]{"Concept", "Name", "Description"};
    private DimensionProperties properties;
    private String source;
    private TableColumn tclConcept;
    private TableColumn tclName;
    private TableColumn tclDescription;
    private Table tblDimensionDescriptor;

    public ConceptNameDescriptorTableViewer(Composite parent, int style, DimensionProperties p, String source) {
        super(parent, style);
        this.properties = p;
        this.source = source;
        this.initComponents();
    }

    private void initComponents() {
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConceptNameDescriptorTableViewer.this.refresh();
            }
        });
        this.setContentProvider((IContentProvider)new TableContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.setInput(this.properties);
        this.tblDimensionDescriptor = this.getTable();
        this.tblDimensionDescriptor.setLinesVisible(true);
        this.tblDimensionDescriptor.setHeaderVisible(true);
        GridData gd_tblDimensionDescriptor = new GridData(131072, 4, true, true, 2, 1);
        gd_tblDimensionDescriptor.heightHint = 160;
        gd_tblDimensionDescriptor.widthHint = 300;
        this.tblDimensionDescriptor.setLayoutData((Object)gd_tblDimensionDescriptor);
        this.tclConcept = new TableColumn(this.tblDimensionDescriptor, 0);
        this.tclConcept.setWidth(120);
        this.tclConcept.setText(CONCEPT);
        this.tclName = new TableColumn(this.tblDimensionDescriptor, 0);
        this.tclName.setWidth(110);
        this.tclName.setText(NAME);
        this.tclDescription = new TableColumn(this.tblDimensionDescriptor, 0);
        this.tclDescription.setText(DESCRIPTION);
        this.tclDescription.setWidth(330);
        this.setColumnProperties(PROPERTIES);
        if (this.properties != null) {
            this.properties.addObserver((Observer)this);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.refresh(true);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.properties != null) {
            this.properties.deleteObserver((Observer)this);
        }
        super.handleDispose(event);
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DimensionProperties) {
                if (ConceptNameDescriptorTableViewer.this.source == "Dimensions") {
                    return ((DimensionProperties)inputElement).getDescriptors().toArray(new ConceptProperties[0]);
                }
                if (ConceptNameDescriptorTableViewer.this.source == "select") {
                    return ((DimensionProperties)inputElement).getSelectors().toArray(new ConceptProperties[0]);
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ConceptProperties) {
                Concept concept = ((ConceptProperties)element).getConcept();
                Attribute attribute = ((ConceptProperties)element).getAttribute();
                switch (columnIndex) {
                    case 0: {
                        return CoreUtils.getCurrentLangName((Object)concept, (String)Activator.getLanguage());
                    }
                    case 1: {
                        return CoreUtils.getCurrentLangName((Object)attribute, (String)Activator.getLanguage());
                    }
                    case 2: {
                        return CoreUtils.getCurrentLang((MultilingualString)attribute.getDescription(), (String)Activator.getLanguage());
                    }
                }
                return "";
            }
            return "";
        }
    }
}

