/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.sorting;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.DimensionsComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.TimeSegmentComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptAttributesComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptParentsComboViewer;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;

public class SorterCompositePanel
extends Composite {
    private MultiSortElemProperties singleSorterProperties;
    protected Button selectButton;
    private Combo cmbType;
    private DimensionsComboViewer cmbDimensionViewer;
    private Combo cmbDimension;
    private ConceptParentsComboViewer cmbConceptViewer;
    private Combo cmbConcept;
    private ConceptAttributesComboViewer cmbAttributeViewer;
    private Combo cmbAttribute;
    private TimeSegmentComboViewer cmbSeriesViewer;
    private Combo cmbSeries;
    private Button azButton;
    private Button zaButton;

    public SorterCompositePanel(Composite parent, int style, MultiSortElemProperties p) {
        super(parent, style);
        this.setBackground(SWTResourceManager.getColor(1));
        this.singleSorterProperties = p;
        this.initComponents();
        this.syncroData();
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        this.setLayout((Layout)gridLayout);
        this.cmbType = new Combo((Composite)this, 0);
        GridData gridData_2 = new GridData(4, 0x1000000, false, true, 1, 1);
        gridData_2.widthHint = 80;
        this.cmbType.setLayoutData((Object)gridData_2);
        this.cmbType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SorterCompositePanel.this.cmbType.getSelectionIndex() == 0) {
                    Concept concept = (Concept)((IStructuredSelection)SorterCompositePanel.this.cmbConceptViewer.getSelection()).getFirstElement();
                    Dimension dimension = (Dimension)((IStructuredSelection)SorterCompositePanel.this.cmbDimensionViewer.getSelection()).getFirstElement();
                    SorterCompositePanel.this.singleSorterProperties.setType('D');
                    SorterCompositePanel.this.singleSorterProperties.setDimension(dimension);
                    SorterCompositePanel.this.singleSorterProperties.setConcept(concept);
                    SorterCompositePanel.this.singleSorterProperties.setAttribute(concept.getNameAttribute());
                    SorterCompositePanel.this.syncroData();
                }
                SorterCompositePanel.this.adjoustCombos();
            }
        });
        this.cmbType.setItems(new String[]{"Dimension", "Period"});
        this.cmbDimensionViewer = new DimensionsComboViewer((Composite)this, 2048, this.singleSorterProperties.getProperties().getDataset(), Activator.getLanguage());
        this.cmbDimension = this.cmbDimensionViewer.getCombo();
        GridData gridData = new GridData(65, -1);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0x1000000;
        gridData.grabExcessVerticalSpace = true;
        this.cmbDimension.setLayoutData((Object)gridData);
        this.cmbDimension.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dimension selection = (Dimension)((StructuredSelection)SorterCompositePanel.this.cmbDimensionViewer.getSelection()).getFirstElement();
                SorterCompositePanel.this.cmbConceptViewer.setInput((Object)selection.getConcept());
                SorterCompositePanel.this.cmbConceptViewer.setSelection((ISelection)new StructuredSelection((Object[])new Concept[]{selection.getConcept()}));
            }
        });
        this.cmbSeriesViewer = new TimeSegmentComboViewer((Composite)this, 2048, this.singleSorterProperties.getProperties().getTimeSeriesProperties().getTimeseries());
        this.cmbSeries = this.cmbSeriesViewer.getCombo();
        this.cmbSeries.setVisibleItemCount(20);
        GridData gd_cmbSeries = new GridData(65, -1);
        gd_cmbSeries.exclude = true;
        this.cmbSeries.setLayoutData((Object)gd_cmbSeries);
        this.cmbSeries.setVisible(false);
        this.cmbConceptViewer = new ConceptParentsComboViewer((Composite)this, 2048, Activator.getLanguage(), true);
        this.cmbConceptViewer.setInput((Object)((Dimension)this.cmbDimensionViewer.getElementAt(0)).getConcept());
        this.cmbConceptViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Concept selection = (Concept)((StructuredSelection)SorterCompositePanel.this.cmbConceptViewer.getSelection()).getFirstElement();
                SorterCompositePanel.this.cmbAttributeViewer.setInput((Object)selection);
                SorterCompositePanel.this.cmbAttributeViewer.getCombo().select(0);
            }
        });
        this.cmbConcept = this.cmbConceptViewer.getCombo();
        this.cmbConcept.setVisibleItemCount(10);
        GridData gridData_1 = new GridData(65, -1);
        gridData_1.horizontalAlignment = 4;
        gridData_1.grabExcessHorizontalSpace = true;
        gridData_1.verticalAlignment = 0x1000000;
        gridData_1.grabExcessVerticalSpace = true;
        this.cmbConcept.setLayoutData((Object)gridData_1);
        this.cmbAttributeViewer = new ConceptAttributesComboViewer((Composite)this, 2048, Activator.getLanguage());
        this.cmbAttributeViewer.setInput((Object)((Concept)this.cmbConceptViewer.getElementAt(0)));
        this.cmbAttribute = this.cmbAttributeViewer.getCombo();
        this.cmbAttribute.setVisibleItemCount(10);
        GridData gridData_3 = new GridData(65, -1);
        gridData_3.horizontalAlignment = 4;
        gridData_3.grabExcessHorizontalSpace = true;
        this.cmbAttribute.setLayoutData((Object)gridData_3);
        this.azButton = new Button((Composite)this, 16);
        this.azButton.setBackground(SWTResourceManager.getColor(1));
        this.azButton.setImage(Activator.getImage("icons/actions/sortaz.png"));
        this.azButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.azButton.setSelection(true);
        this.zaButton = new Button((Composite)this, 16);
        this.zaButton.setBackground(SWTResourceManager.getColor(1));
        this.zaButton.setImage(Activator.getImage("icons/actions/sortza.png"));
        this.zaButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.zaButton.setSelection(false);
    }

    private void adjoustCombos() {
        switch (this.cmbType.getSelectionIndex()) {
            case 0: {
                this.cmbDimension.setVisible(true);
                this.cmbConcept.setVisible(true);
                ((GridData)this.cmbConcept.getLayoutData()).exclude = false;
                this.cmbAttribute.setVisible(true);
                ((GridData)this.cmbSeries.getLayoutData()).exclude = true;
                this.cmbSeries.setVisible(false);
                break;
            }
            case 1: {
                this.cmbDimension.setVisible(false);
                this.cmbConcept.setVisible(false);
                ((GridData)this.cmbConcept.getLayoutData()).exclude = true;
                this.cmbAttribute.setVisible(false);
                ((GridData)this.cmbSeries.getLayoutData()).exclude = false;
                this.cmbSeries.setVisible(true);
                break;
            }
        }
        this.layout(true);
    }

    protected void applyData() {
        if (this.cmbType.getSelectionIndex() == 0) {
            this.singleSorterProperties.setType('D');
            this.singleSorterProperties.setDimension((Dimension)((StructuredSelection)this.cmbDimensionViewer.getSelection()).getFirstElement());
            this.singleSorterProperties.setConcept((Concept)((StructuredSelection)this.cmbConceptViewer.getSelection()).getFirstElement());
            this.singleSorterProperties.setAttribute((Attribute)((StructuredSelection)this.cmbAttributeViewer.getSelection()).getFirstElement());
            this.singleSorterProperties.setObservationPeriod(null);
        } else {
            this.singleSorterProperties.setType('S');
            this.singleSorterProperties.setObservationPeriod((ObservationPeriod)((StructuredSelection)this.cmbSeriesViewer.getSelection()).getFirstElement());
            this.singleSorterProperties.setDimension(null);
            this.singleSorterProperties.setConcept(null);
            this.singleSorterProperties.setAttribute(null);
        }
        this.singleSorterProperties.setAscending(this.azButton.getSelection());
    }

    protected void syncroData() {
        if (this.singleSorterProperties.getType() == 'D') {
            this.cmbType.select(0);
            this.cmbDimensionViewer.setSelection((ISelection)new StructuredSelection((Object[])new Dimension[]{this.singleSorterProperties.getDimension()}));
            this.cmbConceptViewer.setInput((Object)this.singleSorterProperties.getConcept());
            this.cmbConceptViewer.setSelection((ISelection)new StructuredSelection((Object[])new Concept[]{this.singleSorterProperties.getConcept()}));
            this.cmbAttributeViewer.setInput((Object)this.singleSorterProperties.getConcept());
            this.cmbAttributeViewer.setSelection((ISelection)new StructuredSelection((Object[])new Attribute[]{this.singleSorterProperties.getAttribute()}));
        } else {
            this.cmbType.select(1);
            this.cmbSeriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new ObservationPeriod[]{this.singleSorterProperties.getObservationPeriod()}));
        }
        this.adjoustCombos();
        if (this.singleSorterProperties.isAscending()) {
            this.azButton.setSelection(true);
            this.zaButton.setSelection(false);
        } else {
            this.azButton.setSelection(false);
            this.zaButton.setSelection(true);
        }
    }
}

