/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.reference.groups;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModel;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupsDaoFactory;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.MultilangualTabbedEditor;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.dataset.filter.KeyFilterComposite;

public class CustomGroupDialog
extends Dialog {
    private CustomGroupModel model = null;
    private DimensionProperties properties;
    private boolean newGroup;
    private MultilangualTabbedEditor groupDescriptionEditor;
    private Label descriptionLabel;
    private Label lblName;
    private MultilangualTabbedEditor groupNameEditor;
    private Composite panelDown;
    private KeyFilterComposite panelUp;
    private Label label;

    public CustomGroupDialog(Shell parentShell, CustomGroupModel model, DimensionProperties properties) {
        super(parentShell);
        this.model = model;
        this.newGroup = !model.isAlreadyDefined();
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackgroundMode(2);
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        container.setLayout((Layout)gridLayout);
        this.panelUp = new KeyFilterComposite(container, 0, this.model.getSelection(), this.properties);
        this.panelUp.setBackground(SWTResourceManager.getColor(1));
        GridData gd_panelUp = new GridData(4, 0x1000000, true, false);
        gd_panelUp.heightHint = 427;
        this.panelUp.setLayoutData(gd_panelUp);
        this.panelDown = new Composite(container, 0);
        this.panelDown.setBackground(SWTResourceManager.getColor(1));
        GridData gd_panelDown = new GridData(4, 4, false, true);
        gd_panelDown.heightHint = 30;
        this.panelDown.setLayoutData((Object)gd_panelDown);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.verticalSpacing = 3;
        gridLayout_1.horizontalSpacing = 0;
        this.panelDown.setLayout((Layout)gridLayout_1);
        this.lblName = new Label(this.panelDown, 0);
        this.lblName.setBackground(SWTResourceManager.getColor(1));
        this.lblName.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.lblName.setFont(ComponentsCommons.getFont((String)"Arial", (int)10, (int)1));
        GridData gd_lblName = new GridData(4, 0x1000000, true, false);
        gd_lblName.widthHint = 505;
        this.lblName.setLayoutData((Object)gd_lblName);
        this.lblName.setText(Activator.getLocalString("command.label.tools.new.custom.group.name"));
        this.groupNameEditor = new MultilangualTabbedEditor(this.panelDown, 0, this.model.getName().getInstance(), Activator.getLanguage(), 160);
        GridData gd_groupNameEditor = new GridData(4, 4, true, false);
        gd_groupNameEditor.heightHint = 40;
        this.groupNameEditor.setLayoutData((Object)gd_groupNameEditor);
        this.label = new Label(this.panelDown, 258);
        GridData gd_label = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_label.heightHint = 9;
        gd_label.widthHint = 99;
        this.label.setLayoutData((Object)gd_label);
        this.label.setForeground(SWTResourceManager.getColor(224, 255, 255));
        this.descriptionLabel = new Label(this.panelDown, 0);
        this.descriptionLabel.setBackground(SWTResourceManager.getColor(1));
        this.descriptionLabel.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.descriptionLabel.setFont(ComponentsCommons.getFont((String)"Arial", (int)10, (int)1));
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.descriptionLabel.setText(Activator.getLocalString("command.label.tools.new.custom.group.description"));
        this.groupDescriptionEditor = new MultilangualTabbedEditor(this.panelDown, 0, this.model.getDescription().getInstance(), Activator.getLanguage(), 320);
        GridData gd_groupDescriptionEditor = new GridData(4, 4, true, false);
        gd_groupDescriptionEditor.heightHint = 40;
        this.groupDescriptionEditor.setLayoutData((Object)gd_groupDescriptionEditor);
        this.syncroData();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 660);
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        newShell.setBackgroundMode(2);
        super.configureShell(newShell);
        newShell.setText(Activator.getLocalString("command.label.tools.new.custom.groups"));
    }

    protected void applyData() {
        this.groupNameEditor.applyData();
        this.groupDescriptionEditor.applyData();
    }

    protected void syncroData() {
        this.groupNameEditor.syncroData();
        this.groupDescriptionEditor.syncroData();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
            return;
        }
        if (buttonId == 0) {
            this.applyData();
            try {
                if (this.newGroup) {
                    CustomGroupsDaoFactory.create().insert(this.model);
                } else {
                    CustomGroupsDaoFactory.create().update(this.model);
                }
            }
            catch (Exception e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            super.okPressed();
        }
    }
}

