/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.reference.groups;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.reference.groups.DimensionGroupsPanel;

public class GroupsManagerTitleAreaDialog
extends TitleAreaDialog {
    private DatasetProperties properties;
    private CTabFolder cTabFolder;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());

    public GroupsManagerTitleAreaDialog(Shell parentShell, DatasetProperties properties) {
        super(parentShell);
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Activator.getLocalString("command.label.tools.custom.groups"));
        this.setMessage(Activator.getLocalString("command.tooltip.tools.custom.groups"));
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        final Composite area = (Composite)super.createDialogArea(parent);
        area.setBackground(SWTResourceManager.getColor(1));
        final Composite pippo = new Composite(area, 0);
        pippo.setLayout((Layout)new FillLayout(256));
        GridData gd_pippo = new GridData(4, 4, true, false, 1, 1);
        gd_pippo.heightHint = 55;
        pippo.setLayoutData((Object)gd_pippo);
        pippo.setVisible(true);
        CLabel lblNewLabel = new CLabel(pippo, 0x1000000);
        lblNewLabel.setFont(SWTResourceManager.getFont("Tahoma", 8, 1));
        lblNewLabel.setForeground(SWTResourceManager.getColor(4));
        this.formToolkit.adapt((Composite)lblNewLabel);
        this.formToolkit.paintBordersFor((Composite)lblNewLabel);
        lblNewLabel.setText("Custom groups loading. Please wait...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Composite container = new Composite(area, 0);
                        container.setVisible(false);
                        container.setBackground(SWTResourceManager.getColor(1));
                        container.setLayout((Layout)new FillLayout());
                        container.setLayoutData((Object)new GridData(1808));
                        GroupsManagerTitleAreaDialog.this.cTabFolder = new CTabFolder(container, 0x800000);
                        GroupsManagerTitleAreaDialog.this.cTabFolder.setBackground(SWTResourceManager.getColor(1));
                        for (Dimension dimension : GroupsManagerTitleAreaDialog.this.properties.getDataset().getDimensions()) {
                            CTabItem tabItem = new CTabItem(GroupsManagerTitleAreaDialog.this.cTabFolder, 0);
                            tabItem.setText(CoreUtils.getCurrentLangName((Object)dimension, (String)Activator.getLanguage()));
                            tabItem.setControl((Control)new DimensionGroupsPanel((Composite)GroupsManagerTitleAreaDialog.this.cTabFolder, 0, dimension));
                        }
                        if (GroupsManagerTitleAreaDialog.this.cTabFolder.getChildren().length > 0) {
                            GroupsManagerTitleAreaDialog.this.cTabFolder.setSelection(0);
                        }
                        pippo.dispose();
                        container.setVisible(true);
                        area.pack();
                    }
                });
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(510, 400);
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        super.configureShell(newShell);
        newShell.setImage(ComponentsActivator.getImage((String)"icons/groups.png"));
        newShell.setText(Activator.getLocalString("label.custom.groups.manager"));
    }
}

