/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;

public class YearDateComposite
extends Composite {
    private final MeasureDisplayer displayer = new MeasureDisplayer();
    private Text textQuantity;
    private boolean observed;

    public YearDateComposite(Composite parent, int style, String labelContent, Measure m, boolean observed) {
        super(parent, style);
        this.observed = observed;
        Label label = new Label((Composite)this, 0x1000060);
        label.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)64));
        label.setFont(ComponentsCommons.getFont((String)"Arial", (int)8, (int)1));
        label.setAlignment(131072);
        GridData gd_label = new GridData(4, 4, false, true);
        gd_label.heightHint = 12;
        gd_label.widthHint = 6 * labelContent.length();
        label.setLayoutData((Object)gd_label);
        label.setBackground(Display.getCurrent().getSystemColor(22));
        label.setText(labelContent);
        this.textQuantity = new Text((Composite)this, 133120);
        GridData gd_textQuantity = new GridData(4, 0x1000000, true, true);
        gd_textQuantity.heightHint = 12;
        gd_textQuantity.widthHint = 60;
        this.textQuantity.setLayoutData((Object)gd_textQuantity);
        this.textQuantity.setEditable(false);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 2;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
    }

    public void setMeasure(final Measure m) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (m == null) {
                    YearDateComposite.this.textQuantity.setText("");
                } else {
                    YearDateComposite.this.textQuantity.setText(YearDateComposite.this.displayer.getMeasureLabel(m, YearDateComposite.this.observed));
                    YearDateComposite.this.textQuantity.setForeground(YearDateComposite.this.displayer.getForeground(m));
                    YearDateComposite.this.textQuantity.setFont(YearDateComposite.this.displayer.getFont(m));
                }
            }
        });
    }

    public void reset() {
        this.textQuantity.setText("");
    }

    protected void checkSubclass() {
    }
}

