/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class DimensionTableLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private Session session;

    public DimensionTableLabelProvider(Session session) {
        this.session = session;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex() - 1;
        if (element instanceof ObservationSeries) {
            try {
                ObservationSeries obs = (ObservationSeries)element;
                FSDimensionColumnDescriptor descriptor = this.session.getSessionMetadata().getDimColumnDescriptor(columnIndex);
                ReferenceObject ro = CoreUtils.calcColumnReferenceObject((FSDimensionColumnDescriptor)descriptor, (ReferenceObject)obs.getKey(descriptor.getDimensionIdx()));
                if (ro == null) {
                    cell.setText(Activator.getLocalString("label.not.applicable"));
                    return;
                }
                if (ro.equals(ReferenceObject.NULL)) {
                    cell.setText("");
                    return;
                }
                if (ro.equals(ReferenceObject.ALL) || ro.equals(ReferenceObject.OTHERS) || ro.equals(ReferenceObject.UNKNOWN)) {
                    cell.setText(CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (String)"NAME", (String)Activator.getLanguage()));
                    return;
                }
                if (ro.getConcept().equals(descriptor.getConcept())) {
                    String label = CoreUtils.getTextualValue((ReferenceObject)ro, (FSDimensionColumnDescriptor)descriptor, (String)Activator.getLanguage());
                    cell.setText(label);
                } else {
                    cell.setText(CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)ro.getConcept().getNameAttribute(), (String)Activator.getLanguage()));
                }
            }
            catch (TimeseriesServiceException e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            catch (ReferenceServiceException e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                cell.setText("");
            }
        }
    }
}

