/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.wizards.exports;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.Graphics;

public class ConceptExportSelectionPage
extends WizardPage {
    public static final String ID = "org.fao.fi.fishstat.wsconsole.gui.wizards.exports.concep.selection";
    public static final String DEFAULT_FILE_NAME = "concepts.xml";
    private Table tblConceptandrelations;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private CheckboxTableViewer tblvConceptAndRelations;
    private Text txtFile;
    private Button btnSelectAll;
    private Button btnSelectNone;
    private Button btnInvertSelection;
    private Button btnCheckSelected;
    private Button btnOnlyConcepts;
    private Button btnRelsOnly;

    public ConceptExportSelectionPage() {
        super(ID);
        this.setMessage("Select the elements you want export");
        this.setTitle("Concepts / Relationships export wizard");
        this.setDescription("Select the elements you want export");
    }

    public void createControl(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        Composite container = new Composite(parent, 0);
        container.setBackground(SWTResourceManager.getColor(1));
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Composite cmpHigh = this.formToolkit.createComposite(container, 0);
        cmpHigh.setLayout((Layout)new GridLayout(1, false));
        GridData gd_cmpHigh = new GridData(16384, 4, false, false, 1, 1);
        gd_cmpHigh.widthHint = 380;
        cmpHigh.setLayoutData((Object)gd_cmpHigh);
        Label lblListToExport = new Label(cmpHigh, 0);
        lblListToExport.setForeground(SWTResourceManager.getColor(0, 0, 102));
        lblListToExport.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        GridData gd_lblListToExport = new GridData(0x1000000, 0x1000000, true, false, 1, 1);
        gd_lblListToExport.heightHint = 16;
        lblListToExport.setLayoutData((Object)gd_lblListToExport);
        lblListToExport.setBackground(SWTResourceManager.getColor(1));
        lblListToExport.setText("List of concepts/relationships to export");
        Label lblConceptsColor = new Label(cmpHigh, 0);
        lblConceptsColor.setBackground(SWTResourceManager.getColor(1));
        lblConceptsColor.setForeground(Graphics.COLOR_DARK_BLUE);
        lblConceptsColor.setText("Concepts");
        Label lblRelationshipsColor = new Label(cmpHigh, 0);
        lblRelationshipsColor.setBackground(SWTResourceManager.getColor(1));
        lblRelationshipsColor.setForeground(Graphics.COLOR_DARK_RED);
        lblRelationshipsColor.setText("Relationships");
        this.tblvConceptAndRelations = CheckboxTableViewer.newCheckList((Composite)cmpHigh, (int)2050);
        this.tblvConceptAndRelations.setUseHashlookup(true);
        this.tblConceptandrelations = this.tblvConceptAndRelations.getTable();
        GridData gd_tblConceptandrelations = new GridData(4, 4, true, false, 1, 1);
        gd_tblConceptandrelations.widthHint = 347;
        gd_tblConceptandrelations.heightHint = 214;
        this.tblConceptandrelations.setLayoutData((Object)gd_tblConceptandrelations);
        TableViewerColumn tableViewerColumn1 = new TableViewerColumn((TableViewer)this.tblvConceptAndRelations, 0);
        tableViewerColumn1.setLabelProvider((CellLabelProvider)new ConceptAndRelsColumnLabelProvider(1));
        TableColumn tblclmnColumn1 = tableViewerColumn1.getColumn();
        tblclmnColumn1.setWidth(185);
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn((TableViewer)this.tblvConceptAndRelations, 0);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new ConceptAndRelsColumnLabelProvider(2));
        TableColumn tblclmnColumn2 = tableViewerColumn2.getColumn();
        tblclmnColumn2.setWidth(185);
        this.tblvConceptAndRelations.setContentProvider((IContentProvider)new ConceptAndRelationsContentProvider());
        this.tblvConceptAndRelations.setComparator((ViewerComparator)new ConceptAndRelationsComparator());
        this.tblvConceptAndRelations.setInput((Object)this);
        this.tblvConceptAndRelations.setAllChecked(true);
        Composite cmpRigth = this.formToolkit.createComposite(container, 0);
        cmpRigth.setLayout((Layout)new GridLayout(1, false));
        GridData gd_cmpRigth = new GridData(4, 4, true, false, 1, 1);
        gd_cmpRigth.heightHint = 310;
        gd_cmpRigth.widthHint = 72;
        cmpRigth.setLayoutData((Object)gd_cmpRigth);
        this.formToolkit.paintBordersFor(cmpRigth);
        this.btnSelectAll = new Button(cmpRigth, 0);
        this.btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ConceptExportSelectionPage.this.tblvConceptAndRelations.getTable().getItemCount()) {
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(ConceptExportSelectionPage.this.tblvConceptAndRelations.getElementAt(i), true);
                    ++i;
                }
            }
        });
        GridData gd_btnSelectAll = new GridData(4, 4, false, false, 1, 1);
        gd_btnSelectAll.widthHint = 64;
        this.btnSelectAll.setLayoutData((Object)gd_btnSelectAll);
        this.formToolkit.adapt((Control)this.btnSelectAll, true, true);
        this.btnSelectAll.setText("Select all");
        this.btnSelectNone = new Button(cmpRigth, 0);
        this.btnSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ConceptExportSelectionPage.this.tblvConceptAndRelations.getTable().getItemCount()) {
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(ConceptExportSelectionPage.this.tblvConceptAndRelations.getElementAt(i), false);
                    ++i;
                }
            }
        });
        this.btnSelectNone.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnSelectNone, true, true);
        this.btnSelectNone.setText("Select none");
        this.btnInvertSelection = this.formToolkit.createButton(cmpRigth, "Invert selection", 0);
        this.btnInvertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ConceptExportSelectionPage.this.tblvConceptAndRelations.getTable().getItemCount()) {
                    Object element = ConceptExportSelectionPage.this.tblvConceptAndRelations.getElementAt(i);
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(element, !ConceptExportSelectionPage.this.tblvConceptAndRelations.getChecked(element));
                    ++i;
                }
            }
        });
        this.btnInvertSelection.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.btnCheckSelected = new Button(cmpRigth, 0);
        this.btnCheckSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ConceptExportSelectionPage.this.tblvConceptAndRelations.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(element, true);
                    ++n2;
                }
            }
        });
        this.btnCheckSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnCheckSelected, true, true);
        this.btnCheckSelected.setText("Check selected");
        this.btnOnlyConcepts = new Button(cmpRigth, 0);
        this.btnOnlyConcepts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ConceptExportSelectionPage.this.tblvConceptAndRelations.getTable().getItemCount()) {
                    Object element = ConceptExportSelectionPage.this.tblvConceptAndRelations.getElementAt(i);
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(element, element instanceof Concept);
                    ++i;
                }
            }
        });
        this.btnOnlyConcepts.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnOnlyConcepts, true, true);
        this.btnOnlyConcepts.setText("Only concepts");
        this.btnRelsOnly = new Button(cmpRigth, 0);
        this.btnRelsOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ConceptExportSelectionPage.this.tblvConceptAndRelations.getTable().getItemCount()) {
                    Object element = ConceptExportSelectionPage.this.tblvConceptAndRelations.getElementAt(i);
                    ConceptExportSelectionPage.this.tblvConceptAndRelations.setChecked(element, element instanceof Relationship);
                    ++i;
                }
            }
        });
        this.btnRelsOnly.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnRelsOnly, true, true);
        this.btnRelsOnly.setText("Only relations");
        Composite cmpLow = new Composite(container, 0);
        cmpLow.setLayout((Layout)new GridLayout(2, false));
        GridData gd_cmpLow = new GridData(4, 4, false, false, 2, 1);
        gd_cmpLow.heightHint = 54;
        cmpLow.setLayoutData((Object)gd_cmpLow);
        this.formToolkit.adapt(cmpLow);
        this.formToolkit.paintBordersFor(cmpLow);
        Label lblNewLabel_1 = new Label(cmpLow, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblNewLabel_1, true, true);
        lblNewLabel_1.setText("File:");
        new Label(cmpLow, 0);
        this.txtFile = new Text(cmpLow, 2048);
        this.txtFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFile.setText(String.valueOf(System.getProperty("user.home")) + File.separatorChar + DEFAULT_FILE_NAME);
        this.formToolkit.adapt((Control)this.txtFile, true, true);
        final Button btnBrowse = new Button(cmpLow, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(btnBrowse.getShell());
                directoryDialog.setFilterPath("");
                directoryDialog.setMessage("Please select a directory and click OK");
                int lastIndex = ConceptExportSelectionPage.this.txtFile.getText().lastIndexOf(File.separatorChar);
                String filename = lastIndex > 0 ? ConceptExportSelectionPage.this.txtFile.getText().substring(lastIndex + 1) : ConceptExportSelectionPage.this.txtFile.getText();
                String dir = directoryDialog.open();
                if (dir != null) {
                    ConceptExportSelectionPage.this.txtFile.setText(String.valueOf(dir) + File.separatorChar + filename);
                }
            }
        });
        this.formToolkit.adapt((Control)btnBrowse, true, true);
        btnBrowse.setText("Browse");
    }

    protected List<Object> getSelection() {
        LinkedList<Object> res = new LinkedList<Object>();
        Object[] objectArray = this.tblvConceptAndRelations.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            res.add(object);
            ++n2;
        }
        return res;
    }

    protected File getSelectedFile() {
        return new File(this.txtFile.getText());
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private class ConceptAndRelationsComparator
    extends ViewerComparator {
        private ConceptAndRelationsComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Relationship) {
                return -1;
            }
            if (e1 instanceof Relationship && e2 instanceof Concept) {
                return 1;
            }
            if (e1 instanceof Concept && e2 instanceof Concept) {
                return ((Concept)e1).getAcronym().compareTo(((Concept)e2).getAcronym());
            }
            if (e1 instanceof Relationship && e2 instanceof Relationship) {
                return ((Relationship)e1).getAcronym().compareTo(((Relationship)e2).getAcronym());
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class ConceptAndRelationsContentProvider
    implements IStructuredContentProvider {
        private ConceptAndRelationsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<Object> res = new LinkedList<Object>();
            for (Concept concept : ReferenceServiceFactory.getService().getConcepts()) {
                if (CoreCommons.getWorkspaceSystemEntities().isSystemConcept(concept)) continue;
                res.add(concept);
            }
            for (Relationship relationship : ReferenceServiceFactory.getService().getRelationships()) {
                if (CoreCommons.getWorkspaceSystemEntities().isSystemRelationship(relationship)) continue;
                res.add(relationship);
            }
            return res.toArray();
        }
    }

    private class ConceptAndRelsColumnLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public ConceptAndRelsColumnLabelProvider(int column) {
            this.column = column;
        }

        public Color getForeground(Object element) {
            if (element instanceof Concept) {
                return Graphics.COLOR_DARK_BLUE;
            }
            if (element instanceof Relationship) {
                return Graphics.COLOR_DARK_RED;
            }
            return Graphics.COLOR_BLACK;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return this.column == 1 ? ((Concept)element).getAcronym() : ((Concept)element).getName().getValue(Activator.getLanguage());
            }
            if (element instanceof Relationship) {
                return this.column == 1 ? ((Relationship)element).getAcronym() : ((Relationship)element).getName().getValue(Activator.getLanguage());
            }
            return super.getText(element);
        }
    }
}

