/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.wizards.exports;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.trees.DatasetsTreeContentProvider;

public class DatasetExportSelectionPage
extends WizardPage {
    public static final String ID = "org.fao.fi.fishstat.wsconsole.gui.wizards.exports.dataset.selection";
    public static final String DEFAULT_FILE_NAME = "datasets.xml";
    private Tree treDatasetsAndTimeseries;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private CheckboxTreeViewer trevDatasetsAndTimeseries;
    private Text txtFile;

    public DatasetExportSelectionPage() {
        super(ID);
        this.setTitle("Wizard Page title");
        this.setDescription("Wizard Page description");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Composite cmpLeft = this.formToolkit.createComposite(container, 0);
        cmpLeft.setLayout((Layout)new GridLayout(1, false));
        GridData gd_cmpLeft = new GridData(16384, 4, false, false, 1, 1);
        gd_cmpLeft.widthHint = 380;
        cmpLeft.setLayoutData((Object)gd_cmpLeft);
        this.formToolkit.paintBordersFor(cmpLeft);
        Label lblNewLabel = new Label(cmpLeft, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        lblNewLabel.setBackground(SWTResourceManager.getColor(1));
        lblNewLabel.setText("New Label");
        this.trevDatasetsAndTimeseries = new CheckboxTreeViewer(cmpLeft, 2050);
        this.trevDatasetsAndTimeseries.setUseHashlookup(true);
        this.treDatasetsAndTimeseries = this.trevDatasetsAndTimeseries.getTree();
        this.trevDatasetsAndTimeseries.setAutoExpandLevel(2);
        GridData gd_tblConceptandrelations = new GridData(4, 4, true, false, 1, 1);
        gd_tblConceptandrelations.widthHint = 347;
        gd_tblConceptandrelations.heightHint = 214;
        this.treDatasetsAndTimeseries.setLayoutData((Object)gd_tblConceptandrelations);
        TreeViewerColumn treeViewerColumn1 = new TreeViewerColumn((TreeViewer)this.trevDatasetsAndTimeseries, 0);
        treeViewerColumn1.setLabelProvider((CellLabelProvider)new ConceptAndRelsColumnLabelProvider(1));
        TreeColumn treeClmnColumn1 = treeViewerColumn1.getColumn();
        treeClmnColumn1.setWidth(185);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn((TreeViewer)this.trevDatasetsAndTimeseries, 0);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ConceptAndRelsColumnLabelProvider(2));
        TreeColumn treeClmnColumn2 = treeViewerColumn2.getColumn();
        treeClmnColumn2.setWidth(185);
        this.trevDatasetsAndTimeseries.setContentProvider((IContentProvider)new DatasetsTreeContentProvider());
        this.trevDatasetsAndTimeseries.setInput((Object)this);
        this.trevDatasetsAndTimeseries.expandAll();
        this.trevDatasetsAndTimeseries.setAllChecked(true);
        Composite cmpRigth = this.formToolkit.createComposite(container, 0);
        cmpRigth.setLayout((Layout)new GridLayout(1, false));
        GridData gd_cmpRigth = new GridData(4, 4, true, false, 1, 1);
        gd_cmpRigth.heightHint = 310;
        gd_cmpRigth.widthHint = 72;
        cmpRigth.setLayoutData((Object)gd_cmpRigth);
        this.formToolkit.paintBordersFor(cmpRigth);
        Button btnSelectAll = new Button(cmpRigth, 0);
        btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetExportSelectionPage.this.trevDatasetsAndTimeseries.setAllChecked(true);
            }
        });
        GridData gd_btnSelectAll = new GridData(4, 4, false, false, 1, 1);
        gd_btnSelectAll.widthHint = 64;
        btnSelectAll.setLayoutData((Object)gd_btnSelectAll);
        this.formToolkit.adapt((Control)btnSelectAll, true, true);
        btnSelectAll.setText("Select all");
        Button btnSelectNone = new Button(cmpRigth, 0);
        btnSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetExportSelectionPage.this.trevDatasetsAndTimeseries.setAllChecked(false);
            }
        });
        btnSelectNone.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)btnSelectNone, true, true);
        btnSelectNone.setText("Select none");
        Button btnInvertSelection = this.formToolkit.createButton(cmpRigth, "Invert selection", 0);
        btnInvertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        btnInvertSelection.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Button btnCheckSelected = new Button(cmpRigth, 0);
        btnCheckSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DatasetExportSelectionPage.this.trevDatasetsAndTimeseries.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    DatasetExportSelectionPage.this.trevDatasetsAndTimeseries.setChecked(element, true);
                    ++n2;
                }
            }
        });
        btnCheckSelected.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.formToolkit.adapt((Control)btnCheckSelected, true, true);
        btnCheckSelected.setText("Check selected");
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd_composite = new GridData(4, 4, false, false, 2, 1);
        gd_composite.heightHint = 54;
        composite.setLayoutData((Object)gd_composite);
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        Label lblNewLabel_1 = new Label(composite, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblNewLabel_1, true, true);
        lblNewLabel_1.setText("File:");
        new Label(composite, 0);
        this.txtFile = new Text(composite, 2048);
        this.txtFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFile.setText(String.valueOf(System.getProperty("user.home")) + File.separatorChar + DEFAULT_FILE_NAME);
        this.formToolkit.adapt((Control)this.txtFile, true, true);
        final Button btnBrowse = new Button(composite, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(btnBrowse.getShell());
                directoryDialog.setFilterPath("");
                directoryDialog.setMessage("Please select a directory and click OK");
                int lastIndex = DatasetExportSelectionPage.this.txtFile.getText().lastIndexOf(File.separatorChar);
                String filename = lastIndex > 0 ? DatasetExportSelectionPage.this.txtFile.getText().substring(lastIndex + 1) : DatasetExportSelectionPage.this.txtFile.getText();
                String dir = directoryDialog.open();
                if (dir != null) {
                    DatasetExportSelectionPage.this.txtFile.setText(String.valueOf(dir) + File.separatorChar + filename);
                }
            }
        });
        this.formToolkit.adapt((Control)btnBrowse, true, true);
        btnBrowse.setText("Browse");
    }

    protected List<Object> getSelection() {
        LinkedList<Object> res = new LinkedList<Object>();
        Object[] objectArray = this.trevDatasetsAndTimeseries.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            res.add(object);
            ++n2;
        }
        return res;
    }

    protected File getSelectedFile() {
        return new File(this.txtFile.getText());
    }

    private class ConceptAndRelsColumnLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public ConceptAndRelsColumnLabelProvider(int column) {
            this.column = column;
        }

        public String getText(Object element) {
            if (element instanceof Dataset) {
                return this.column == 1 ? ((Dataset)element).getAcronym() : ((Dataset)element).getName().getValue(Activator.getLanguage());
            }
            if (element instanceof Timeseries) {
                return this.column == 1 ? ((Timeseries)element).getAcronym() : ((Timeseries)element).getName().getValue(Activator.getLanguage());
            }
            return super.getText(element);
        }
    }
}

