/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.wizards.exports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureExporterImpl;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.wizards.exports.ConceptExportSelectionPage;
import org.fao.fi.fishstat.gui.wizards.exports.CustomgroupsExportSelectionPage;
import org.fao.fi.fishstat.gui.wizards.exports.DatasetExportSelectionPage;
import org.fao.fi.fishstat.gui.wizards.exports.MainExportPage;
import org.fao.fi.fishstat.gui.wizards.exports.ReferenceExportSelectionPage;
import org.fao.fi.fishstat.gui.wizards.exports.RelationshipsExportSelectionPage;

public class MainExportWizard
extends Wizard {
    protected boolean canFinish = false;

    public MainExportWizard() {
        this.setWindowTitle("New Export Wizard");
    }

    public void addPages() {
        this.addPage((IWizardPage)new MainExportPage());
        this.addPage((IWizardPage)new ConceptExportSelectionPage());
        this.addPage((IWizardPage)new ReferenceExportSelectionPage());
        this.addPage((IWizardPage)new RelationshipsExportSelectionPage());
        this.addPage((IWizardPage)new DatasetExportSelectionPage());
        this.addPage((IWizardPage)new CustomgroupsExportSelectionPage());
    }

    public boolean performFinish() {
        ReferenceCSVService referenceCSVService;
        FileWriter fileWriter;
        WorkspaceStructureExporterImpl workspaceStructureExporter;
        OutputStreamWriter writer;
        File candidateFile;
        IWizardPage lastRelevantPage = ((MainExportPage)this.getPage("org.fao.fi.fishstat.wsconsole.gui.wizards.exports.main")).getNextPage();
        if (lastRelevantPage instanceof ConceptExportSelectionPage && lastRelevantPage.isPageComplete() && ((ConceptExportSelectionPage)lastRelevantPage).getSelection().size() > 0) {
            block44: {
                candidateFile = ((ConceptExportSelectionPage)lastRelevantPage).getSelectedFile();
                if (candidateFile.isDirectory()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Directory specified", (String)"You specified a directory. Please pecify a valid file name.");
                    return false;
                }
                if (candidateFile.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"File already existent", (String)"The filename file already exists. Do you want to overwrite it?")) {
                        candidateFile.delete();
                    } else {
                        return false;
                    }
                }
                if (candidateFile.createNewFile()) break block44;
                MessageDialog.openError((Shell)this.getShell(), (String)"File opening failure", (String)"Operation failed: Failed to open file for writing.");
                return false;
            }
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(candidateFile), "UTF-8");
                workspaceStructureExporter = new WorkspaceStructureExporterImpl();
                workspaceStructureExporter.exportConcepts((Writer)writer, ((ConceptExportSelectionPage)lastRelevantPage).getSelection());
                writer.flush();
                writer.close();
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export file successfully written", (String)("You exported all concepts information on " + candidateFile.getAbsolutePath()));
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.wizards.exports", "concept export failed", (Throwable)e));
                e.printStackTrace();
            }
        }
        if (lastRelevantPage instanceof ReferenceExportSelectionPage && lastRelevantPage.isPageComplete()) {
            Concept concept;
            block45: {
                candidateFile = ((ReferenceExportSelectionPage)lastRelevantPage).getSelectedFile();
                concept = ((ReferenceExportSelectionPage)lastRelevantPage).getSelectedConcept();
                if (candidateFile.isDirectory()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Directory specified", (String)"You specified a directory. Please pecify a valid file name.");
                    return false;
                }
                if (candidateFile.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"File already existent", (String)"The filename file already exists. Do you want to overwrite it?")) {
                        candidateFile.delete();
                    } else {
                        return false;
                    }
                }
                if (candidateFile.createNewFile()) break block45;
                MessageDialog.openError((Shell)this.getShell(), (String)"File opening failure", (String)"Operation failed: Failed to open file for writing.");
                return false;
            }
            try {
                fileWriter = new FileWriter(candidateFile);
                referenceCSVService = ReferenceCSVService.instance();
                referenceCSVService.download(concept, (Writer)fileWriter, null);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export file successfully written", (String)("You exported all concepts information on " + candidateFile.getAbsolutePath()));
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.wizards.exports", "concept export failed", (Throwable)e));
                e.printStackTrace();
            }
        }
        if (lastRelevantPage instanceof RelationshipsExportSelectionPage && lastRelevantPage.isPageComplete()) {
            Relationship relationship;
            block46: {
                candidateFile = ((RelationshipsExportSelectionPage)lastRelevantPage).getSelectedFile();
                relationship = ((RelationshipsExportSelectionPage)lastRelevantPage).getSelectedRelationship();
                if (candidateFile.isDirectory()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Directory specified", (String)"You specified a directory. Please pecify a valid file name.");
                    return false;
                }
                if (candidateFile.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"File already existent", (String)"The filename file already exists. Do you want to overwrite it?")) {
                        candidateFile.delete();
                    } else {
                        return false;
                    }
                }
                if (candidateFile.createNewFile()) break block46;
                MessageDialog.openError((Shell)this.getShell(), (String)"File opening failure", (String)"Operation failed: Failed to open file for writing.");
                return false;
            }
            try {
                fileWriter = new FileWriter(candidateFile);
                referenceCSVService = ReferenceCSVService.instance();
                referenceCSVService.download(relationship, (Writer)fileWriter, null);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export file successfully written", (String)("You exported all concepts information on " + candidateFile.getAbsolutePath()));
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.wizards.exports", "relationship export failed", (Throwable)e));
                e.printStackTrace();
            }
        }
        if (lastRelevantPage instanceof DatasetExportSelectionPage) {
            if (lastRelevantPage.isPageComplete() && ((DatasetExportSelectionPage)lastRelevantPage).getSelection().size() > 0) {
                block47: {
                    candidateFile = ((DatasetExportSelectionPage)lastRelevantPage).getSelectedFile();
                    if (candidateFile.isDirectory()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Directory specified", (String)"You specified a directory. Please pecify a valid file name.");
                        return false;
                    }
                    if (candidateFile.exists()) {
                        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"File already existent", (String)"The filename file already exists. Do you want to overwrite it?")) {
                            candidateFile.delete();
                        } else {
                            return false;
                        }
                    }
                    if (candidateFile.createNewFile()) break block47;
                    MessageDialog.openError((Shell)this.getShell(), (String)"File opening failure", (String)"Operation failed: Failed to open file for writing.");
                    return false;
                }
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(candidateFile), "UTF-8");
                    workspaceStructureExporter = new WorkspaceStructureExporterImpl();
                    workspaceStructureExporter.exportDatasets((Writer)writer, ((DatasetExportSelectionPage)lastRelevantPage).getSelection());
                    writer.flush();
                    writer.close();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Export file successfully written", (String)("You exported all dataset information on " + candidateFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.wizards.exports", "dataset export failed", (Throwable)e));
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"No dataset selected", (String)"Nothing to export!");
            }
        }
        if (lastRelevantPage instanceof CustomgroupsExportSelectionPage) {
            if (lastRelevantPage.isPageComplete() && ((CustomgroupsExportSelectionPage)lastRelevantPage).getSelection().size() > 0) {
                block48: {
                    candidateFile = ((CustomgroupsExportSelectionPage)lastRelevantPage).getSelectedFile();
                    if (candidateFile.isDirectory()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Directory specified", (String)"You specified a directory. Please pecify a valid file name.");
                        return false;
                    }
                    if (candidateFile.exists()) {
                        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"File already existent", (String)"The filename file already exists. Do you want to overwrite it?")) {
                            candidateFile.delete();
                        } else {
                            return false;
                        }
                    }
                    if (candidateFile.createNewFile()) break block48;
                    MessageDialog.openError((Shell)this.getShell(), (String)"File opening failure", (String)"Operation failed: Failed to open file for writing.");
                    return false;
                }
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(candidateFile), "UTF-8");
                    workspaceStructureExporter = new WorkspaceStructureExporterImpl();
                    workspaceStructureExporter.exportCustomgroups((Writer)writer, ((CustomgroupsExportSelectionPage)lastRelevantPage).getSelection());
                    writer.flush();
                    writer.close();
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Export file successfully written", (String)("You exported all custom-groups information on " + candidateFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui.wizards.exports", "custom-groups export failed", (Throwable)e));
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"No custom-groups selected", (String)"Nothing to export!");
            }
        }
        return true;
    }
}

