/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;
import org.osgi.framework.FrameworkUtil;

public class DownloadNewWorkspacePage
extends WizardPage {
    public static final String ID = "org.fao.fi.fishstat.gui.gui.workspaces.wizard.download";
    private InstallNewWorkspaceWizard wizard;
    private Composite container;
    private Label lblFileName;

    public DownloadNewWorkspacePage(InstallNewWorkspaceWizard wizard) {
        super(ID);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.wizard = wizard;
        this.setTitle("FishStatJ workspace download");
        this.setDescription("downloading workspace");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FormLayout());
        Label lblURLtext = new Label(this.container, 16384);
        lblURLtext.setText(this.wizard.getAutoUpdateWks().getUrl());
        FormData fd_lblURLtext = new FormData();
        fd_lblURLtext.top = new FormAttachment(0, 10);
        fd_lblURLtext.left = new FormAttachment(0, 5);
        fd_lblURLtext.right = new FormAttachment(100, -10);
        lblURLtext.setLayoutData((Object)fd_lblURLtext);
        Label lblFileText = new Label(this.container, 16384);
        FormData fd_lblFileText = new FormData();
        fd_lblFileText.left = new FormAttachment(0, 5);
        fd_lblFileText.top = new FormAttachment((Control)lblURLtext, 10);
        lblFileText.setLayoutData((Object)fd_lblFileText);
        lblFileText.setText("Download location:");
        this.lblFileName = new Label(this.container, 16384);
        FormData fd_lblFileName = new FormData();
        fd_lblFileName.left = new FormAttachment(0, 5);
        fd_lblFileName.top = new FormAttachment((Control)lblFileText, 10);
        fd_lblFileName.right = new FormAttachment(100, -10);
        this.lblFileName.setLayoutData((Object)fd_lblFileName);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadNewWorkspacePage.this.doHTTPdownload();
                }
            });
        }
    }

    private void doHTTPdownload() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DownloadNewWorkspacePage.this.Get_URL(DownloadNewWorkspacePage.this.wizard.getAutoUpdateWks().getUrl(), monitor);
                }
            });
            this.downloadCompleted();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void downloadCompleted() {
        if (this.wizard.getWsFile() == null) {
            this.setMessage("Download failed", 3);
        } else {
            this.lblFileName.setText(this.wizard.getWsFile());
            this.lblFileName.redraw();
            this.setPageComplete(true);
            this.setMessage("The download is complete", 1);
        }
        this.getWizard().getContainer().updateButtons();
        this.container.update();
    }

    private void Get_URL(String httpURL, IProgressMonitor progressMon) {
        int retry = 0;
        while (retry < 6) {
            block17: {
                HttpURLConnection httpConnn = null;
                FileOutputStream fileOutStream = null;
                try {
                    String filePath = String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop" + File.separator + httpURL.substring(httpURL.lastIndexOf(47) + 1);
                    File downloadFile = new File(filePath);
                    long contentLength = -1L;
                    if (downloadFile.exists() && downloadFile.length() > 10000L) {
                        contentLength = this.get_ContentLegth(httpURL);
                        if (downloadFile.length() == contentLength) {
                            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "file already on disk; file length=" + downloadFile.length()));
                            this.wizard.setWsFile(filePath);
                            progressMon.done();
                            return;
                        }
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "download from " + httpURL));
                    httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
                    httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getVersion().toString());
                    httpConnn.setConnectTimeout(20000);
                    httpConnn.setRequestMethod("GET");
                    if (downloadFile.exists() && downloadFile.length() > 10000L) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "resuming download at offset " + downloadFile.length()));
                        this.setMessage("resuming download at offset " + downloadFile.length());
                        httpConnn.setRequestProperty("Range", "bytes=" + downloadFile.length() + "-");
                        fileOutStream = new FileOutputStream(filePath, true);
                    } else {
                        fileOutStream = new FileOutputStream(filePath);
                    }
                    httpConnn.connect();
                    int code = httpConnn.getResponseCode();
                    if (httpConnn.getContentLengthLong() != -1L) {
                        contentLength = httpConnn.getContentLengthLong();
                    }
                    if (code == 200 || code == 206) {
                        progressMon.beginTask("Downloading workspace", (int)(contentLength / 10000L));
                        InputStream httpInStream = httpConnn.getInputStream();
                        int bytesRead = -1;
                        byte[] buffer = new byte[10000];
                        while ((bytesRead = httpInStream.read(buffer)) != -1) {
                            fileOutStream.write(buffer, 0, bytesRead);
                            progressMon.worked(1);
                        }
                        fileOutStream.close();
                        httpInStream.close();
                        httpConnn.disconnect();
                        this.wizard.setWsFile(filePath);
                        Activator.getDefault().getLog().log((IStatus)new Status(1, ID, String.valueOf(filePath) + " download OK"));
                        return;
                    }
                    fileOutStream.close();
                    httpConnn.disconnect();
                    Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error: received response code=" + code + " (expected 200)"));
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    Activator.getDefault().getLog().log((IStatus)new Status(4, ID, "Error: " + exp.getMessage(), (Throwable)exp));
                    if (fileOutStream != null) {
                        try {
                            fileOutStream.close();
                        }
                        catch (Exception downloadFile) {
                            // empty catch block
                        }
                    }
                    if (httpConnn == null) break block17;
                    try {
                        httpConnn.disconnect();
                    }
                    catch (Exception downloadFile) {
                        // empty catch block
                    }
                }
            }
            String myPath = String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop" + File.separator + httpURL.substring(httpURL.lastIndexOf(47) + 1);
            File myFile = new File(myPath);
            Activator.getDefault().getLog().log((IStatus)new Status(1, ID, "---------- download retry #" + retry + " file=" + myFile.length()));
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++retry;
        }
        progressMon.done();
    }

    private long get_ContentLegth(String url) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (Exception e) {
            return -1L;
        }
        finally {
            conn.disconnect();
        }
    }
}

