/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.common.api.MultilingualString;

public class AttributeType
implements Serializable {
    private static final long serialVersionUID = 1821005114580326621L;
    private static final String TYPE_STRING = "STRING";
    private static final String TYPE_MULTILINGUAL_STRING = "MULTILINGUAL_STRING";
    private static final String TYPE_DECIMAL = "DECIMAL";
    private static final String TYPE_SMALLINT = "SMALLINT";
    private static final String TYPE_INTEGER = "INTEGER";
    private static final String TYPE_DOUBLE = "DOUBLE";
    private static final String TYPE_REAL = "REAL";
    private static final String TYPE_BOOLEAN = "BOOLEAN";
    private static final String TYPE_DATE = "DATE";
    public static final AttributeType STRING = new AttributeType("STRING");
    public static final AttributeType MULTILINGUAL_STRING = new AttributeType("MULTILINGUAL_STRING");
    public static final AttributeType DECIMAL = new AttributeType("DECIMAL");
    public static final AttributeType SMALLINT = new AttributeType("SMALLINT");
    public static final AttributeType INTEGER = new AttributeType("INTEGER");
    public static final AttributeType DOUBLE = new AttributeType("DOUBLE");
    public static final AttributeType REAL = new AttributeType("REAL");
    public static final AttributeType BOOLEAN = new AttributeType("BOOLEAN");
    public static final AttributeType DATE = new AttributeType("DATE");
    private static final List<String> TYPE_KEYS = Collections.unmodifiableList(Arrays.asList("STRING", "MULTILINGUAL_STRING", "DECIMAL", "SMALLINT", "INTEGER", "DOUBLE", "REAL", "BOOLEAN", "DATE"));
    public static final Set<AttributeType> TYPES = Collections.unmodifiableSet(new HashSet<AttributeType>(Arrays.asList(STRING, MULTILINGUAL_STRING, DECIMAL, SMALLINT, INTEGER, DOUBLE, REAL, BOOLEAN, DATE)));
    private static final Map<String, Class<?>> RUNTIME_TYPES = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(AttributeType.TYPE_STRING, String.class);
            this.put(AttributeType.TYPE_MULTILINGUAL_STRING, MultilingualString.class);
            this.put(AttributeType.TYPE_DECIMAL, BigDecimal.class);
            this.put(AttributeType.TYPE_SMALLINT, Short.class);
            this.put(AttributeType.TYPE_INTEGER, Long.class);
            this.put(AttributeType.TYPE_DOUBLE, Double.class);
            this.put(AttributeType.TYPE_REAL, Float.class);
            this.put(AttributeType.TYPE_BOOLEAN, Boolean.class);
            this.put(AttributeType.TYPE_DATE, Date.class);
        }
    };
    private static final Map<String, Integer> JDBC_TYPES = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(AttributeType.TYPE_STRING, 12);
            this.put(AttributeType.TYPE_MULTILINGUAL_STRING, 12);
            this.put(AttributeType.TYPE_DECIMAL, 3);
            this.put(AttributeType.TYPE_SMALLINT, 5);
            this.put(AttributeType.TYPE_INTEGER, -5);
            this.put(AttributeType.TYPE_DOUBLE, 8);
            this.put(AttributeType.TYPE_REAL, 7);
            this.put(AttributeType.TYPE_BOOLEAN, 5);
            this.put(AttributeType.TYPE_DATE, 91);
        }
    };
    private String type;

    private AttributeType(String type) {
        this.type = type;
    }

    private String getType() {
        return this.type;
    }

    public static AttributeType valueOf(String type) {
        if (TYPE_KEYS.contains(type)) {
            return new AttributeType(type);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public String toString() {
        return this.getType();
    }

    public Class<?> getRuntimeType() {
        return RUNTIME_TYPES.get(this.type);
    }

    public int getJdbcType() {
        return JDBC_TYPES.get(this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeType)) {
            return false;
        }
        AttributeType other = (AttributeType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

