/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.cache.ReferenceObjectCache;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;

public class ReferenceObjectImpl
implements ReferenceObject,
StructuralChangeEventListener {
    private Concept concept;
    private Map<Attribute, Object> attributes;
    private final Object _attributesLock = new Object();
    private Object dto;
    private int hashcode;
    private Identifier identifier;

    public ReferenceObjectImpl(Object dto, Concept concept) {
        if (dto == null) {
            throw new IllegalArgumentException("Expecting not null refrence object DTO");
        }
        if (concept == null) {
            throw new IllegalArgumentException("Expecting not null concept DTO");
        }
        this.dto = dto;
        this.concept = concept;
        String id = null;
        try {
            id = Commons.getDTOIdentifier((Object)dto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.identifier = IdentifierHelper.instance((String)id);
        this.initHashCode();
        this.register();
    }

    private void register() {
        RegistryFactory.getRegistry((Object)this.concept).registerListener(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE, (StructuralChangeEventListener)this);
        RegistryFactory.getRegistry((Object)this.concept).registerListener(StructuralChangeEvent.WORKSPACE_CHANGE, (StructuralChangeEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAttributesMap() {
        Object object = this._attributesLock;
        synchronized (object) {
            this.attributes = new LinkedHashMap<Attribute, Object>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAttributesMap() {
        Object object = this._attributesLock;
        synchronized (object) {
            if (this.attributes != null) {
                this.attributes.clear();
                this.attributes = null;
            }
        }
    }

    private Map<Attribute, Object> getAttributesMap() throws ReferenceServiceException {
        Object object = this._attributesLock;
        synchronized (object) {
            try {
                if (this.attributes == null) {
                    this.resetAttributesMap();
                    Collection<Attribute> meta_attributes = this.getConcept().getAttributes();
                    for (Attribute attribute : meta_attributes) {
                        Object value = null;
                        if (attribute.getType().equals(AttributeType.MULTILINGUAL_STRING)) {
                            MultilingualString multistring = new MultilingualString();
                            for (String language : MultilingualString.LANGUAGES) {
                                String language_string = (String)Commons.getDTOAttributeByAcronym((Object)this.getDTO(), (String)(String.valueOf(attribute.getAcronym()) + "_" + language));
                                multistring.setValue(language, language_string);
                            }
                            value = multistring;
                        } else {
                            value = Commons.getDTOAttributeByAcronym((Object)this.getDTO(), (String)attribute.getAcronym());
                        }
                        this.attributes.put(attribute, value);
                    }
                }
                return this.attributes;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to get object attributes", e);
            }
        }
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public Object getAttribute(String acronym) throws ReferenceServiceException {
        return this.getAttribute(this.getConcept().getAttribute(acronym));
    }

    @Override
    public Object getAttribute(Attribute meta) throws ReferenceServiceException {
        return this.getAttributesMap().get(meta);
    }

    @Override
    public Map<Attribute, Object> getAttributes() throws ReferenceServiceException {
        return Collections.unmodifiableMap(this.getAttributesMap());
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public void setAttribute(Attribute attribute, Object value) throws ReferenceServiceException {
        try {
            if (attribute == null) {
                throw new IllegalArgumentException("Expecting not null attribute value");
            }
            if (!this.getConcept().getAttributes().contains(attribute)) {
                throw new IllegalArgumentException("Meta attribute not defined: " + attribute);
            }
            if ("ID".equalsIgnoreCase(attribute.getAcronym())) {
                throw new IllegalArgumentException("Can not set the ID attribute");
            }
            if (attribute.getType().equals(AttributeType.MULTILINGUAL_STRING)) {
                if (!(value instanceof MultilingualString)) {
                    throw new IllegalArgumentException(AttributeType.MULTILINGUAL_STRING + " value expected");
                }
                Commons.setMultilingualDTOAttribute((Object)this.getDTO(), (String)attribute.getAcronym(), (MultilingualString)((MultilingualString)value));
            } else {
                Commons.setDTOAttribute((Object)this.getDTO(), (String)attribute.getAcronym(), (Object)value, attribute.getType().getRuntimeType());
            }
            ReferenceServiceHelper.getReferenceDAO(this.getConcept().getAcronym()).update(Commons.getDTOPk((Object)this.getDTO()), this.getDTO());
            this.getAttributesMap().put(attribute, value);
            ReferenceObjectCache.getCache(this.getConcept()).remove(this.getId());
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set attribute: " + attribute, e);
        }
    }

    @Override
    public void setAttributes(Map<Attribute, Object> attributes) throws ReferenceServiceException {
        if (attributes == null) {
            throw new IllegalArgumentException("Expecting not null attribute values");
        }
        this.resetAttributesMap();
        for (Map.Entry<Attribute, Object> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("[").append(this.getId()).append("]");
            for (Map.Entry<Attribute, Object> entry : this.getAttributes().entrySet()) {
                buffer.append("[").append(entry.getKey().getAcronym()).append("=").append(entry.getValue()).append("]");
            }
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private void initHashCode() {
        int prime = 31;
        this.hashcode = 1;
        this.hashcode = 31 * this.hashcode + (this.getConcept() == null ? 0 : this.getConcept().hashCode());
        this.hashcode = 31 * this.hashcode + (this.getId() == null ? 0 : this.getId().hashCode());
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject other = (ReferenceObject)obj;
        if (this.getConcept() == null ? other.getConcept() != null : !this.getConcept().equals(other.getConcept())) {
            return false;
        }
        return this.getId().equals(other.getId());
    }

    @Override
    public void setAttribute(String acronym, Object value) throws ReferenceServiceException {
        if (acronym == null) {
            throw new IllegalArgumentException("Expecting not null attribute acronym");
        }
        try {
            Attribute meta = this.getConcept().getAttribute(acronym);
            this.setAttribute(meta, value);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set attribute: " + acronym + " to: " + value, e);
        }
    }

    public void onStructuralChangeEvent(StructuralChangeEvent change) throws IllegalStateException {
        try {
            this.dto = null;
            this.clearAttributesMap();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to propagate structural change to the object: " + this.identifier, e);
        }
    }

    private Object getDTO() throws Exception {
        if (this.dto == null) {
            this.dto = ReferenceServiceHelper.getReferenceDAO(this.concept.getAcronym()).findById(this.identifier.toString());
        }
        return this.dto;
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.clearAttributesMap();
            }
            catch (Exception exception) {
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }
}

