/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.FIESMeasureSymbol;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureFactory;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DatasetDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeseriesManagementTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    private void fire() throws Exception {
        System.out.println("firing changes...");
        Commons.fire();
        System.out.println("changes fired.");
    }

    @Test
    public void testRemoveDataset() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TEST_DATASET");
        if (dataset != null) {
            TimeseriesManagementServiceFactory.getService().removeDataset(dataset);
            this.fire();
        }
    }

    @Test
    public void testCreateDataset() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TEST_DATASET");
        if (dataset != null) {
            System.out.println("dataset already exists");
        } else {
            System.out.println("creating dataset...");
            MultilingualString name = new MultilingualString();
            name.setValue("en", "Species distribution name");
            MultilingualString description = new MultilingualString();
            description.setValue("en", "Species distribution description");
            Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
            Concept measure = ReferenceServiceFactory.getService().getConcept("MEASURE");
            List<DimensionDescriptor> dimensions = Collections.unmodifiableList(Arrays.asList(DescriptorsFactory.createDimensionDescriptor(country.getAcronym(), country.getName(), country.getDescription(), country, country.getAttribute("UN_CODE"), false), DescriptorsFactory.createDimensionDescriptor(measure.getAcronym(), measure.getName(), measure.getDescription(), measure, measure.getAttribute("CODE"), true)));
            DatasetDescriptor descriptor = DescriptorsFactory.createDatasetDescriptor(new DataSource("TEST_DS"), dimensions, "TEST_DATASET", name, description, "http://blog.libero.it/cycom", new Version("1.0", null, null), "F.Calderini");
            dataset = TimeseriesManagementServiceFactory.getService().createDataset(descriptor);
            System.out.println("dataset created: " + dataset);
            this.fire();
        }
    }

    @Test
    public void testCreateTimeseries() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TEST_DATASET");
        Timeseries timeseries = dataset.getTimeseries("LENGTH");
        if (timeseries != null) {
            System.out.println("timeseries already exists");
        } else {
            System.out.println("creating timeseries...");
            MultilingualString name = new MultilingualString();
            name.setValue("en", "Capture length name");
            MultilingualString description = new MultilingualString();
            description.setValue("en", "Capture length description");
            TimeseriesDescriptor descriptor = DescriptorsFactory.createTimeseriesDescriptor(dataset, new DataSource("Calderini"), "LENGTH", name, description, TimeResolution.YEAR, new ObservationPeriod("Y2000"), new ObservationPeriod("Y2009"), null, new Version("1.0", new Date(), " F.Calderini"));
            timeseries = TimeseriesManagementServiceFactory.getService().createTimeseries(descriptor);
            System.out.println("timeseries created: " + timeseries);
            this.fire();
        }
    }

    @Test
    public void testAddObservation() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TEST_DATASET");
        Timeseries timeseries = dataset.getTimeseries("LENGTH");
        ObservationSeries series = timeseries.create();
        Concept dimension = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept measure_dimension = ReferenceServiceFactory.getService().getConcept("MEASURE");
        series.setKeys(new MultiReferenceObject(new ReferenceObject[]{dimension.getObject("UN_CODE", (Object)new Long(380L)), measure_dimension.getObject(IdentifierFactory.instance((String)"00000006"))}));
        LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
        for (ObservationPeriod period : timeseries.getObservationPeriods()) {
            Measure measure = MeasureFactory.create();
            measure.setValue(10.0);
            measure.setStatus((MeasureStatus)FIESMeasureSymbol.F);
            measures.put(period, measure);
        }
        series.setMeasures(measures);
        System.out.println("adding observation series: " + series);
        timeseries.add(series);
        System.out.println("series added.");
    }

    @Test
    public void testRemoveObservations() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TEST_DATASET");
        Timeseries timeseries = dataset.getTimeseries("LENGTH");
        ArrayList observations = new ArrayList(timeseries.getObservations());
        System.out.println("removing observarion series...");
        for (ObservationSeries series : observations) {
            timeseries.remove(series);
        }
        System.out.println("observation series removed.");
        Assert.assertTrue((String)"Not all the observations have been removed", (timeseries.getObservations().size() == 0 ? 1 : 0) != 0);
    }
}

