/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.register.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<T>
extends AbstractSet<T>
implements Set<T> {
    private static final String DUMMY = "DUMMY";
    WeakHashMap<T, String> backingStore;

    public WeakHashSet() {
        this.backingStore = new WeakHashMap();
    }

    public WeakHashSet(Collection<? extends T> c) {
        this.backingStore = new WeakHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll((Collection<? extends T>)c);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.backingStore = new WeakHashMap(initialCapacity, loadFactor);
    }

    public WeakHashSet(int initialCapacity) {
        this.backingStore = new WeakHashMap(initialCapacity);
    }

    @Override
    public boolean isEmpty() {
        return this.backingStore.keySet().isEmpty();
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return this.backingStore.put(o, DUMMY) == null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            changed |= this.backingStore.put(iter.next(), DUMMY) != DUMMY;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.backingStore.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingStore.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingStore.keySet().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.backingStore.keySet().hashCode();
    }

    @Override
    public Iterator<T> iterator() {
        return this.backingStore.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.backingStore.keySet().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backingStore.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backingStore.keySet().retainAll(c);
    }

    @Override
    public int size() {
        return this.backingStore.keySet().size();
    }

    @Override
    public Object[] toArray() {
        return this.backingStore.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingStore.keySet().toArray(a);
    }

    @Override
    public String toString() {
        return this.backingStore.keySet().toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

