/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.MeasureImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class ObservationSeriesImpl
implements ObservationSeries {
    private static final String GET_SYMBOL = "getSymbol";
    private static final String GET_VALUE = "getValue";
    private static Map<ObservationPeriod, String> getValueMethods = Collections.synchronizedMap(new HashMap());
    private static Map<ObservationPeriod, String> getSymbolMethods = Collections.synchronizedMap(new HashMap());
    private Object dto;
    private Timeseries timeseries;
    private MultiReferenceObject keys;
    private ListOrderedMap<ObservationPeriod, Measure> measures;
    private ListOrderedMap<CalculatedMeasureDefinition, Measure> calculatedMeasures;

    public ObservationSeriesImpl(Object dto, Timeseries timeseries) throws TimeseriesServiceException {
        try {
            if (dto == null) {
                throw new IllegalArgumentException("Expecting not null series DTO");
            }
            if (timeseries == null) {
                throw new IllegalArgumentException("Expecting not null timeseries");
            }
            this.dto = dto;
            this.timeseries = timeseries;
            List<Dimension> dimensions = timeseries.getDataset().getDimensions();
            ReferenceObject[] keys_array = new ReferenceObject[dimensions.size()];
            int i = 0;
            for (Dimension dimension : dimensions) {
                Object code;
                Attribute attribute;
                Concept concept = dimension.getConcept();
                ReferenceObject key = concept.getObject(attribute = dimension.getAttribute(), code = Commons.getDTOAttributeByAcronym((Object)dto, (String)concept.getAcronym()));
                if (key == null) {
                    key = ReferenceObject.UNKNOWN;
                }
                keys_array[i++] = key;
            }
            this.keys = new MultiReferenceObject(keys_array);
            this.measures();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to instantiate a Series object", e);
        }
    }

    private ListOrderedMap<ObservationPeriod, Measure> measures() throws Exception {
        if (this.measures == null) {
            this.measures = new ListOrderedMap();
            List<ObservationPeriod> periods = this.timeseries.getObservationPeriods();
            for (ObservationPeriod period : periods) {
                double value = (Double)Commons.getDTOAttributeByMethodName((Object)this.dto, (String)this.getValueMethodName(period));
                String symbol = (String)Commons.getDTOAttributeByMethodName((Object)this.dto, (String)this.getSymbolMethodName(period));
                this.measures.put((Object)period, (Object)new MeasureImpl(value, new MeasureStatus(symbol)));
            }
        }
        return this.measures;
    }

    @Override
    public Map<ObservationPeriod, Measure> getMeasures() {
        try {
            return Collections.unmodifiableMap(this.measures());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get series measures", e);
        }
    }

    private String getValueMethodName(ObservationPeriod period) {
        String name = getValueMethods.get(period);
        if (name == null) {
            String normalised_period = period.toString().replaceAll("Q", "Q".toLowerCase(Locale.ENGLISH)).replaceAll("M", "M".toLowerCase(Locale.ENGLISH));
            name = GET_VALUE + normalised_period;
            getValueMethods.put(period, name);
        }
        return name;
    }

    private String getSymbolMethodName(ObservationPeriod period) {
        String name = getSymbolMethods.get(period);
        if (name == null) {
            String normalised_period = period.toString().replaceAll("Q", "Q".toLowerCase(Locale.ENGLISH)).replaceAll("M", "M".toLowerCase(Locale.ENGLISH));
            name = GET_SYMBOL + normalised_period;
            getSymbolMethods.put(period, name);
        }
        return name;
    }

    public String toString() {
        return TimeseriesServiceHelper.seriesToString(this);
    }

    @Override
    public void setMeasures(Map<ObservationPeriod, Measure> measures) throws TimeseriesServiceException {
        throw new UnsupportedOperationException("Measures can not be set");
    }

    @Override
    public Measure getMeasure(ObservationPeriod period) throws TimeseriesServiceException {
        try {
            if (period == null) {
                throw new IllegalArgumentException("Observation period can not be null");
            }
            return (Measure)this.measures().get((Object)period);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the measure for: " + period, e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservationSeries)) {
            return false;
        }
        ObservationSeries other = (ObservationSeries)obj;
        return !(this.keys == null ? other.getKeys() != null : !this.keys.equals((Object)other.getKeys()));
    }

    private ListOrderedMap<CalculatedMeasureDefinition, Measure> calculatedMeasures() {
        if (this.calculatedMeasures == null) {
            this.calculatedMeasures = TimeseriesServiceHelper.evaluateCalculatedMeasures(this);
        }
        return this.calculatedMeasures;
    }

    @Override
    public Map<CalculatedMeasureDefinition, Measure> getCalculatedMeasures() throws TimeseriesServiceException {
        return this.calculatedMeasures();
    }

    @Override
    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    @Override
    public void resetCalculatedMeasures() {
        if (this.calculatedMeasures != null) {
            this.calculatedMeasures.clear();
            this.calculatedMeasures = null;
        }
    }

    @Override
    public Measure getCalculatedMeasure(CalculatedMeasureDefinition definition) {
        return (Measure)this.calculatedMeasures().get((Object)definition);
    }

    @Override
    public Measure getCalculatedMeasure(int index) throws TimeseriesServiceException {
        return (Measure)this.calculatedMeasures().getValue(index);
    }

    @Override
    public ReferenceObject getKey(Concept dimension) {
        return (ReferenceObject)this.keys.asMap().get(dimension);
    }

    @Override
    public ReferenceObject getKey(int index) {
        return this.keys.elementAt(index);
    }

    @Override
    public Measure getMeasure(int index) {
        try {
            return (Measure)this.measures().getValue(index);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the measure for index: " + index, e);
        }
    }

    @Override
    public MultiReferenceObject getKeys() {
        return this.keys;
    }

    @Override
    public void setKeys(MultiReferenceObject keys) {
        this.keys = keys;
    }

    @Override
    public void setMeasure(ObservationPeriod period, Measure measure) {
        throw new UnsupportedOperationException("Measures can not be set");
    }

    @Override
    public void setMeasure(int index, Measure measure) {
        throw new UnsupportedOperationException("Measures can not be set");
    }
}

