/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.util.Collection;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesService;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesFactory;

public class TimeseriesServiceImpl
implements TimeseriesService {
    @Override
    public Dataset getDataset(String acronym) throws TimeseriesServiceException {
        try {
            return DatasetFactory.instance().getDataset(acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("unable to get dataset: " + e.getMessage(), e);
        }
    }

    @Override
    public Dataset getDataset(Identifier id) throws TimeseriesServiceException {
        try {
            return DatasetFactory.instance().getDataset(id);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("finder method call failed: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Dataset> getDatasets() throws TimeseriesServiceException {
        try {
            return DatasetFactory.instance().getDatasets();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("unable to get datasets: " + e.getMessage(), e);
        }
    }

    @Override
    public Timeseries getTimeseries(Identifier id) throws TimeseriesServiceException {
        if (id == null) {
            throw new IllegalArgumentException("Timeseries identifier can not be null");
        }
        try {
            return TimeseriesFactory.instance().getTimeseries(id);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get timeseries: " + e.getMessage(), e);
        }
    }
}

