/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.status;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.FIESMeasureSymbol;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;

public class MeasureStatusCalculatorFactory {
    private static Map<DataSource, MeasureStatusCalculator> instances = new HashMap<DataSource, MeasureStatusCalculator>();

    static {
        MeasureStatusCalculatorFactory.register(DataSource.UNDEFINED, new MeasureStatusCalculator(){

            @Override
            public void reset() {
            }

            @Override
            public void calculate(ObservationSeries aggregated, ObservationSeries series) {
                for (Measure measure : aggregated.getMeasures().values()) {
                    measure.setStatus(MeasureStatus.NOT_SPECIFIED);
                }
            }
        });
        MeasureStatusCalculatorFactory.register(DataSource.FAO, new MeasureStatusCalculator(){
            private Map<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>> statusMap;

            @Override
            public void reset() {
                if (this.statusMap != null) {
                    this.statusMap.clear();
                }
                this.statusMap = new HashMap<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>>();
            }

            @Override
            public void calculate(ObservationSeries aggregated, ObservationSeries series) {
                Map<ObservationPeriod, Measure> series_measures = series.getMeasures();
                Map<ObservationPeriod, Measure> aggregated_measures = aggregated.getMeasures();
                MultiReferenceObject multikey = aggregated.getKeys();
                Map<ObservationPeriod, DoubleValue> status_row = this.statusMap.get(multikey);
                if (status_row == null) {
                    status_row = new HashMap<ObservationPeriod, DoubleValue>();
                    this.statusMap.put(multikey, status_row);
                }
                for (ObservationPeriod period : series.getTimeseries().getObservationPeriods()) {
                    Measure observation_measure = series_measures.get(period);
                    Measure aggregated_measure = aggregated_measures.get(period);
                    DoubleValue value = status_row.get(period);
                    if (value == null) {
                        value = new DoubleValue();
                        status_row.put(period, value);
                    }
                    this.setAggregatedStatus(aggregated_measure, observation_measure, value);
                }
            }

            private void setAggregatedStatus(Measure aggregated, Measure measure, DoubleValue value) {
                if (aggregated == null || measure == null) {
                    throw new IllegalArgumentException("Measure can not be null");
                }
                MeasureStatus aggregated_symbol = aggregated.getStatus();
                MeasureStatus measure_symbol = measure.getStatus();
                if (aggregated_symbol == null) {
                    aggregated_symbol = MeasureStatus.NOT_SPECIFIED;
                }
                if (measure_symbol == null) {
                    measure_symbol = MeasureStatus.NOT_SPECIFIED;
                }
                if (aggregated.getValue() == 0.0 && measure.getValue() == 0.0) {
                    if (aggregated_symbol.equals(FIESMeasureSymbol.ZERO) || measure_symbol.equals(FIESMeasureSymbol.ZERO)) {
                        aggregated.setStatus(FIESMeasureSymbol.ZERO);
                    } else if (aggregated_symbol.equals(FIESMeasureSymbol.DOT) || aggregated_symbol.equals(FIESMeasureSymbol.TRIPLE_DOT) || measure_symbol.equals(FIESMeasureSymbol.DOT) || measure_symbol.equals(FIESMeasureSymbol.TRIPLE_DOT)) {
                        aggregated.setStatus(FIESMeasureSymbol.DOT);
                    } else if (aggregated_symbol.equals(FIESMeasureSymbol.DASH) || measure_symbol.equals(FIESMeasureSymbol.DASH)) {
                        aggregated.setStatus(FIESMeasureSymbol.DASH);
                    } else {
                        aggregated.setStatus(MeasureStatus.NOT_SPECIFIED);
                    }
                } else {
                    if (measure_symbol.equals(FIESMeasureSymbol.F)) {
                        value.addEstimate(measure.getValue());
                    } else {
                        value.addNotEstimate(measure.getValue());
                    }
                    aggregated.setStatus(value.status());
                }
            }

            final class DoubleValue {
                private double estimate = 0.0;
                private double notEstimate = 0.0;

                public double getEstimate() {
                    return this.estimate;
                }

                public void setEstimate(double estimate) {
                    this.estimate = estimate;
                }

                public void addEstimate(double value) {
                    this.estimate += value;
                }

                public double getNotEstimate() {
                    return this.notEstimate;
                }

                public void setNotEstimate(double notEstimate) {
                    this.notEstimate = notEstimate;
                }

                public void addNotEstimate(double value) {
                    this.notEstimate += value;
                }

                public MeasureStatus status() {
                    if (Math.abs(this.estimate) > Math.abs(this.notEstimate)) {
                        return FIESMeasureSymbol.F;
                    }
                    return MeasureStatus.NOT_SPECIFIED;
                }
            }
        });
    }

    public static final MeasureStatusCalculator instance(DataSource dataSource) {
        MeasureStatusCalculator calculator = instances.get(dataSource);
        if (calculator == null) {
            calculator = instances.get(DataSource.UNDEFINED);
        }
        return calculator;
    }

    public static final void register(DataSource dataSource, MeasureStatusCalculator calculator) {
        instances.put(dataSource, calculator);
    }
}

