/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProductionTimeseriesTestCase {
    private static Dataset capture;
    private static Timeseries capture_quantity;
    private static final int AGGREGATE_ALL_MAX_TIME = 6000;
    private static final int GROUP_BY_CONTINENT_MAX_TIME = 10000;
    private static final int GROUP_BY_COUNTRY_MAX_TIME = 7000;
    private static final long TOP_OTHERS_MAX_TIME = 12000L;
    private static final long FILTER_MAX_TIME = 2000L;

    @BeforeClass
    public static void setUpClass() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        Timer.start();
        capture = TimeseriesServiceFactory.getService().getDataset("CAPTURE");
        capture_quantity = capture.getTimeseries("QUANTITY");
        Timer.stop();
        System.out.println("Set up took: " + Timer.timeElapsed() + "ms");
    }

    @Before
    public void setUpTest() throws Exception {
        capture_quantity.reset();
        System.out.println("getting observations...");
        Timer.start();
        capture_quantity.getObservations();
        Timer.stop();
        System.out.println("ready in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testGetLocalCodeList() throws Exception {
        Timer.start();
        Collection<ReferenceObject> result = capture_quantity.getAllReferencedObjects(capture.getDimension("SPECIES"));
        Timer.stop();
        System.out.println("found " + result.size() + " codes in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testCrustaceansSelection() throws Exception {
        Selection selection = Selection.instance();
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        Concept faostat_group = ReferenceServiceFactory.getService().getConcept("FAOSTAT_GROUP");
        Set crustaceans = ReferenceServiceFactory.getService().getRelationship("FAOSTAT_GROUP_SPECIES").getChildren(faostat_group.getObject("GROUP_CODE", (Object)"1553"));
        selection.addAll(species, crustaceans);
        Concept areas = ReferenceServiceFactory.getService().getConcept("AREA");
        Concept inland_marine = ReferenceServiceFactory.getService().getConcept("INLAND_MARINE");
        Set inland = ReferenceServiceFactory.getService().getRelationship("INLAND_MARINE_AREA").getChildren(inland_marine.getObject("CODE", (Object)5L));
        Set marine = ReferenceServiceFactory.getService().getRelationship("INLAND_MARINE_AREA").getChildren(inland_marine.getObject("CODE", (Object)10L));
        selection.addAll(areas, inland);
        selection.addAll(areas, marine);
        Timer.start();
        capture_quantity.filter(selection);
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "ms");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to filter crustaceans"), (Timer.timeElapsed() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testAllSpeciesSelection() throws Exception {
        Selection selection = Selection.instance();
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        Collection all = species.getObjects();
        selection.addAll(species, all);
        Timer.start();
        capture_quantity.filter(selection);
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "ms");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to filter all species"), (Timer.timeElapsed() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testTunaSelection() throws Exception {
        Selection selection = Selection.instance();
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        selection.add(species, species.getObject("ALPHA_3_CODE", (Object)"YFT"));
        Concept areas = ReferenceServiceFactory.getService().getConcept("AREA");
        selection.add(areas, areas.getObject("CODE", (Object)"87"));
        Timer.start();
        capture_quantity.filter(selection);
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "ms");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to filter tuna catches in Southeast Pacific"), (Timer.timeElapsed() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testAggregateAll() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        Concept area = ReferenceServiceFactory.getService().getConcept("AREA");
        ReferenceObject all = ReferenceObject.ALL;
        selection.add(country, all);
        selection.add(species, all);
        selection.add(area, all);
        System.out.println("aggregating all...");
        Timer.start();
        capture_quantity.aggregate(selection);
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to aggregate all"), (Timer.timeElapsed() < 6000L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupByCountry() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        selection.add(country, country.getObject("UN_CODE", (Object)380L));
        System.out.println("grouping by country...");
        Timer.start();
        capture_quantity.aggregate(selection);
        List<ObservationSeries> result = capture_quantity.getObservations();
        Timer.stop();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Country"), (Timer.timeElapsed() < 7000L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupByContinent() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        for (ReferenceObject object : continent.getObjects()) {
            selection.add(country, object);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by continent...");
        Timer.start();
        capture_quantity.aggregate(selection);
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Continent"), (Timer.timeElapsed() < 10000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTotals() throws Exception {
        System.out.println("calculating totals...");
        ObservationSeries result = capture_quantity.getTotals();
        System.out.println("Took: " + Timer.timeElapsed() + "msec to calculate totals: " + result);
    }

    @Test
    public void testCalculateTopOthersNumber() throws Exception {
        TopCriteria criteria = new TopCriteria(ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1"), TopCriteria.CriteriaType.TOP_RECORDS_NUMBER, 5.0);
        System.out.println("calculating top others (number)...");
        Timer.start();
        capture_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        for (ObservationSeries observation : result) {
            System.out.println(observation);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(number)"), (Timer.timeElapsed() < 12000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersValue() throws Exception {
        TopCriteria criteria = new TopCriteria(ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_no_1"), TopCriteria.CriteriaType.TOP_RECORDS_VALUE, 100.0);
        System.out.println("calculating top others (value)...");
        Timer.start();
        capture_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        for (ObservationSeries observation : result) {
            System.out.println(observation);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(value)"), (Timer.timeElapsed() < 12000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersPercent() throws Exception {
        TopCriteria criteria = new TopCriteria(ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1"), TopCriteria.CriteriaType.TOP_RECORDS_PERCENT, 20.0);
        System.out.println("calculating top others (percent)...");
        Timer.start();
        capture_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = capture_quantity.getObservations();
        for (ObservationSeries observation : result) {
            System.out.println(observation);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(percent)"), (Timer.timeElapsed() < 12000L ? 1 : 0) != 0);
    }
}

