/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SbtTimeseriesTestCase {
    private static final long TOTALS_MAX_TIME = 2000L;
    private static Dataset sbt_surface;
    private static Timeseries sbt_surface_quantity;

    @BeforeClass
    public static void setUpClass() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        sbt_surface = TimeseriesServiceFactory.getService().getDataset("SBT_SURFACE");
        sbt_surface_quantity = sbt_surface.getTimeseries("QUANTITY");
    }

    @Before
    public void setUpTest() throws Exception {
        sbt_surface_quantity.reset();
        System.out.println("getting observations...");
        Timer.start();
        sbt_surface_quantity.getObservations();
        Timer.stop();
        System.out.println("ready in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testCalculateTotals() throws Exception {
        System.out.println("calculating totals...");
        Timer.start();
        ObservationSeries result = sbt_surface_quantity.getTotals();
        Timer.stop();
        System.out.println("calculated totals in " + Timer.timeElapsed() + "msec:\n" + result);
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate totals"), (Timer.timeElapsed() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersNumber() throws Exception {
        TopCriteria criteria = new TopCriteria(ReferenceObject.ALL, TopCriteria.CriteriaType.TOP_RECORDS_NUMBER, 1.0);
        sbt_surface_quantity.aggregate(criteria, new ObservationPeriod("Y2008M7"));
        List<ObservationSeries> result = sbt_surface_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec\n");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Found: " + result.size() + " observations, should be 2"), (result.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testObservationPeriods() throws Exception {
        List<ObservationPeriod> periods = sbt_surface_quantity.getObservationPeriods();
        for (ObservationPeriod period : periods) {
            System.out.println(period);
        }
    }
}

