/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ThreadedTicker
extends Job {
    private int SLEEP_TIME;
    private int maxTics;
    private int counter;
    private Runnable runnable;

    public ThreadedTicker(int maxTics) {
        super("ThreadedTicker");
        this.setSystem(true);
        this.setUser(false);
        this.maxTics = maxTics;
        this.SLEEP_TIME = 500;
    }

    public ThreadedTicker(int maxTics, float machineIndicator) {
        super("ThreadedTicker");
        this.maxTics = maxTics;
        this.SLEEP_TIME = (int)(machineIndicator > 0.0f ? machineIndicator : (float)this.SLEEP_TIME);
        this.setSystem(true);
        this.setUser(false);
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public void stopTicker() {
        this.counter = this.maxTics;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.counter = 1;
        while (this.counter <= this.maxTics) {
            if (this.runnable != null) {
                this.runnable.run();
            }
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++this.counter;
        }
        return Status.OK_STATUS;
    }

    public boolean isRunning() {
        return this.counter <= this.maxTics;
    }

    public int getCounter() {
        return this.counter;
    }
}

