/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.DimensionMetadataPanel;

public class DimensionTabbedDisplay
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private List<Dimension> dimensions;
    private String lang = null;
    private Label lblNoSelection;
    private CLabel lblTitle;
    private CTabFolder tabFolder;
    private CTabItem[] tabitems;
    private DimensionMetadataPanel[] composites;

    public DimensionTabbedDisplay(Composite parent, int style, String lang) {
        super(parent, style);
        this.lang = lang;
        this.initComponents();
    }

    private void initComponents() {
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.lblTitle = new CLabel((Composite)this, 0);
        this.lblTitle.setForeground(SWTResourceManager.getColor(10));
        this.lblTitle.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblTitle.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblTitle.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblTitle.setBackgroundMode(1);
        this.lblTitle.setText("Dataset dimensions:");
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setBackgroundMode(2);
        GridData gridData = new GridData(4, 128, true, false, 1, 1);
        gridData.heightHint = 196;
        gridData.widthHint = 500;
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabFolder.setBackground(ComponentsCommons.getColor(1));
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setSelectionBackground(ComponentsCommons.getColor(32));
    }

    public void renderDataset(Dataset dataset) {
        if (dataset != null) {
            try {
                this.lblTitle.setText(dataset.getName().getValue(this.lang));
                this.dimensions = dataset.getDimensions();
            }
            catch (TimeseriesServiceException e) {
                ComponentsCommons.showExceptionWithStack(e);
            }
            if (this.lblNoSelection != null && !this.lblNoSelection.isDisposed()) {
                this.lblNoSelection.dispose();
            }
            if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
                this.tabFolder.dispose();
            }
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            GridData gridData = new GridData(4, 4, true, true, 1, 1);
            gridData.widthHint = 535;
            this.tabFolder.setLayoutData((Object)gridData);
            this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
            this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
            this.tabFolder.setBorderVisible(true);
            int keysize = this.dimensions.size();
            this.tabitems = new CTabItem[keysize];
            this.composites = new DimensionMetadataPanel[keysize];
            int i = 0;
            while (i < this.dimensions.size()) {
                this.tabitems[i] = new CTabItem(this.tabFolder, 0);
                this.tabitems[i].setText(CoreUtils.getCurrentLang((MultilingualString)this.dimensions.get(i).getName(), (String)this.lang));
                this.composites[i] = new DimensionMetadataPanel((Composite)this.tabFolder, 0, this.dimensions.get(i), this.lang);
                this.tabitems[i].setControl((Control)this.composites[i]);
                ++i;
            }
            this.tabFolder.setSelection(this.tabitems[0]);
            this.layout(true);
        } else {
            if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
                this.tabFolder.dispose();
            }
            if (this.lblNoSelection != null && !this.lblNoSelection.isDisposed()) {
                this.lblNoSelection.dispose();
            }
            this.lblNoSelection = new Label((Composite)this, 0x1000000);
            this.lblNoSelection.setAlignment(0x1000000);
            this.lblNoSelection.setText(ComponentsActivator.getDefault().getLocalString("label.no.dataset.selected"));
            this.layout(true);
        }
    }
}

