/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.dialogs;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.db.DbWorkspaceManager;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class FishstatWorkspaceFolderSelector
extends TitleAreaDialog {
    private Tree treeDriveFolders;
    private TreeViewer trwvDriveFolders;
    private File workspaceSelected;
    private Button buttonOk = null;
    private boolean newWorkspace;
    final LabelProvider labelProvider = new LabelProvider(){
        private Image iconFolder = ComponentsActivator.getImage("icons/folder.png");
        private Image iconFSDB = ComponentsActivator.getImage("icons/database.png");

        public Image getImage(Object element) {
            return this.getIcon((File)element);
        }

        public String getText(Object element) {
            return ((File)element).getName();
        }

        private Image getIcon(File file) {
            if (file != null && file.isDirectory()) {
                if (!FishstatWorkspaceFolderSelector.this.newWorkspace && DbWorkspaceManager.isValidWorkspace((File)file)) {
                    return this.iconFSDB;
                }
                return this.iconFolder;
            }
            return this.iconFolder;
        }
    };
    final ViewerComparator viewerSorter = new ViewerComparator(){

        public int category(Object element) {
            File file = (File)element;
            if (file.isDirectory()) {
                return 0;
            }
            return 1;
        }
    };
    final ViewerFilter directoryFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ((File)element).isDirectory() && !((File)element).getName().startsWith("$") && !((File)element).getName().startsWith(".");
        }
    };

    public FishstatWorkspaceFolderSelector(Shell parentShell, boolean newWorkspace) {
        super(parentShell);
        this.newWorkspace = newWorkspace;
    }

    protected Control createDialogArea(Composite parent) {
        File[] roots;
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui.components", "icons/database.png"));
        if (this.newWorkspace) {
            this.setTitle("FishstatJ new workspace folder selection");
            this.setMessage("choose an empty folder where to create the new workspace");
        } else {
            this.setTitle("FishstatJ workspace selection");
            this.setMessage("Choose a valid workspace folder");
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 455;
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblDiskSelection = new Label(container, 0);
        lblDiskSelection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDiskSelection.setText(String.valueOf(ComponentsActivator.getDefault().getLocalString("label.select.drive.colon")) + " ");
        final ComboViewer cmbvDrives = new ComboViewer(container, 8);
        Combo cmbvDriveSelector = cmbvDrives.getCombo();
        cmbvDriveSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FishstatWorkspaceFolderSelector.this.trwvDriveFolders.setInput(((IStructuredSelection)cmbvDrives.getSelection()).getFirstElement());
                FishstatWorkspaceFolderSelector.this.treeDriveFolders.setFocus();
            }
        });
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            cmbvDrives.add((Object)file);
            ++n2;
        }
        cmbvDriveSelector.select(0);
        cmbvDriveSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.trwvDriveFolders = new TreeViewer(container, 2048);
        this.trwvDriveFolders.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                File selection = (File)((StructuredSelection)event.getSelection()).getFirstElement();
                if (FishstatWorkspaceFolderSelector.this.buttonOk == null) {
                    return;
                }
                if (FishstatWorkspaceFolderSelector.this.newWorkspace) {
                    if (FishstatWorkspaceFolderSelector.this.isAnEmptyFolder(selection)) {
                        FishstatWorkspaceFolderSelector.this.buttonOk.setEnabled(true);
                    } else {
                        FishstatWorkspaceFolderSelector.this.buttonOk.setEnabled(false);
                    }
                } else if (DbWorkspaceManager.isValidWorkspace((File)selection)) {
                    FishstatWorkspaceFolderSelector.this.buttonOk.setEnabled(true);
                } else {
                    FishstatWorkspaceFolderSelector.this.buttonOk.setEnabled(false);
                }
            }
        });
        this.treeDriveFolders = this.trwvDriveFolders.getTree();
        this.treeDriveFolders.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (FishstatWorkspaceFolderSelector.this.getButton(0).isEnabled()) {
                    FishstatWorkspaceFolderSelector.this.buttonPressed(0);
                } else {
                    if (FishstatWorkspaceFolderSelector.this.treeDriveFolders.getSelection().length > 0) {
                        FishstatWorkspaceFolderSelector.this.treeDriveFolders.getSelection()[0].setExpanded(!FishstatWorkspaceFolderSelector.this.treeDriveFolders.getSelection()[0].getExpanded());
                    }
                    FishstatWorkspaceFolderSelector.this.trwvDriveFolders.refresh(true);
                }
            }
        });
        this.treeDriveFolders.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.trwvDriveFolders.setContentProvider((IContentProvider)new ContentProvider());
        this.trwvDriveFolders.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.trwvDriveFolders.setFilters(new ViewerFilter[]{this.directoryFilter});
        this.trwvDriveFolders.setComparator(this.viewerSorter);
        this.trwvDriveFolders.setInput(((IStructuredSelection)cmbvDrives.getSelection()).getFirstElement());
        this.treeDriveFolders.setFocus();
        this.trwvDriveFolders.setSelection((ISelection)new StructuredSelection((Object)new File(Platform.getLocation().toString())), true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttonOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.buttonOk.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public File getSelectedWorkspaceFolder() {
        return this.workspaceSelected;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    private boolean isAnEmptyFolder(File file) {
        if (file == null || !file.isDirectory()) {
            return false;
        }
        return file.list() != null && file.list().length == 0;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.workspaceSelected = (File)((StructuredSelection)this.trwvDriveFolders.getSelection()).getFirstElement();
        }
        super.buttonPressed(buttonId);
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] files = ((File)parentElement).listFiles();
            if (files == null) {
                return new Object[0];
            }
            return files;
        }

        public Object getParent(Object element) {
            return ((File)element).getParentFile();
        }

        public boolean hasChildren(Object element) {
            File file = (File)element;
            File[] files = file.listFiles();
            return files != null && files.length != 0;
        }

        public Object[] getElements(Object inputElement) {
            Object[] files = ((File)inputElement).listFiles();
            if (files == null) {
                return new Object[0];
            }
            return files;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            FishstatWorkspaceFolderSelector.this.getShell().setText(String.valueOf(ComponentsActivator.getDefault().getLocalString("label.now.browsing.colon")) + " " + newInput);
        }
    }
}

