/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.providers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;

public class CalculatedMesauresProvidersFactory {
    private static CalculatedMeasuresContentProvider contentProvider;
    private static CalculatedMeasuresLabelProvider labelProvider;
    private static CalculatedMeasuresSorter sorter;

    public static CalculatedMeasuresContentProvider getContentProvider() {
        if (contentProvider == null) {
            contentProvider = new CalculatedMeasuresContentProvider();
        }
        return contentProvider;
    }

    public static CalculatedMeasuresLabelProvider getLabelProvider(String lang) {
        if (labelProvider == null) {
            labelProvider = new CalculatedMeasuresLabelProvider(lang);
        }
        return labelProvider;
    }

    public static CalculatedMeasuresSorter getSorter() {
        if (sorter == null) {
            sorter = new CalculatedMeasuresSorter();
        }
        return sorter;
    }

    private static class CalculatedMeasuresContentProvider
    implements IStructuredContentProvider {
        private CalculatedMeasuresContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CalculatedMeasuresProperties) {
                CalculatedMeasuresProperties p = (CalculatedMeasuresProperties)inputElement;
                return p.getMeasures().values().toArray(new CalculatedMeasureDefinitionWrapper[0]);
            }
            return new CalculatedMeasureDefinition[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class CalculatedMeasuresLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private String lang;

        public CalculatedMeasuresLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CalculatedMeasureDefinitionWrapper) {
                if (columnIndex == 0) {
                    return ((CalculatedMeasureDefinitionWrapper)element).getMeasureName();
                }
                if (columnIndex == 1) {
                    MultilingualString description = ((CalculatedMeasureDefinitionWrapper)element).getMeasure().getFunction().getDescription();
                    if (description != null) {
                        return CoreUtils.getCurrentLang((MultilingualString)description, (String)this.lang);
                    }
                    return "";
                }
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof CalculatedMeasureDefinitionWrapper) {
                return ((CalculatedMeasureDefinitionWrapper)element).getMeasureName();
            }
            return "";
        }
    }

    private static class CalculatedMeasuresSorter
    extends ViewerComparator {
        private CalculatedMeasuresSorter() {
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            return super.compare(viewer, (Object)((CalculatedMeasureDefinitionWrapper)c1).getMeasureName(), (Object)((CalculatedMeasureDefinitionWrapper)c2).getMeasureName());
        }
    }
}

