/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.providers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class PeriodsSettingsFactory {
    private static PeriodsSettingsContentProvider contentProvider;
    private static PeriodsSettingsLabelProvider labelProvider;
    private static PeriodsSettingsdSorter sorter;

    public static PeriodsSettingsContentProvider getContentProvider() {
        if (contentProvider == null) {
            contentProvider = new PeriodsSettingsContentProvider();
        }
        return contentProvider;
    }

    public static PeriodsSettingsLabelProvider getLabelProvider(String lang) {
        if (labelProvider == null) {
            labelProvider = new PeriodsSettingsLabelProvider(lang);
        }
        return labelProvider;
    }

    public static PeriodsSettingsdSorter getSorter() {
        if (sorter == null) {
            sorter = new PeriodsSettingsdSorter();
        }
        return sorter;
    }

    private static class PeriodsSettingsContentProvider
    implements IStructuredContentProvider {
        private PeriodsSettingsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TimeSeriesProperties) {
                TimeSeriesProperties tsprop = (TimeSeriesProperties)inputElement;
                return tsprop.getTimeseries().getObservationPeriods().toArray(new ObservationPeriod[0]);
            }
            return new ObservationPeriod[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class PeriodsSettingsLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private String lang;

        public PeriodsSettingsLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ObservationPeriod && columnIndex == 1) {
                return ((ObservationPeriod)element).getISO8601();
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof ObservationPeriod) {
                return ((ObservationPeriod)element).toString();
            }
            return "";
        }
    }

    private static class PeriodsSettingsdSorter
    extends ViewerComparator {
        private PeriodsSettingsdSorter() {
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            return super.compare(viewer, (Object)((ObservationPeriod)c1).toString(), (Object)((ObservationPeriod)c2).toString());
        }
    }
}

