/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.management.descriptors;

import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.AttributeDescriptorImpl;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.ConceptDescriptorImpl;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.RelationshipDescriptorImpl;

public class DescriptorsFactory {
    public static AttributeDescriptor createAttributeDescriptor(Identifier concept_id, String acronym, MultilingualString name, MultilingualString description, AttributeType type, short size, short scale, boolean is_code, boolean is_name) {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl();
        descriptor.setConceptId(concept_id);
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setType(type);
        descriptor.setSize(size);
        descriptor.setScale(scale);
        descriptor.setCodeAttribute(is_code);
        descriptor.setNameAttribute(is_name);
        return descriptor;
    }

    public static AttributeDescriptor createAttributeDescriptor(Attribute attribute) {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl();
        descriptor.setConceptId(attribute.getConcept().getId());
        descriptor.setAcronym(attribute.getAcronym());
        descriptor.setName(attribute.getName());
        descriptor.setDescription(attribute.getDescription());
        descriptor.setType(attribute.getType());
        descriptor.setSize(attribute.getSize());
        descriptor.setScale(attribute.getScale());
        descriptor.setCodeAttribute(attribute.isCodeAttribute());
        descriptor.setNameAttribute(attribute.isNameAttribute());
        return descriptor;
    }

    public static ConceptDescriptor createConceptDescriptor(String acronym, MultilingualString name, MultilingualString description, Version version) {
        ConceptDescriptorImpl descriptor = new ConceptDescriptorImpl();
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setVersion(version);
        return descriptor;
    }

    public static ConceptDescriptor createConceptDescriptor(Concept concept) {
        ConceptDescriptorImpl descriptor = new ConceptDescriptorImpl();
        descriptor.setAcronym(concept.getAcronym());
        descriptor.setName(concept.getName());
        descriptor.setDescription(concept.getDescription());
        descriptor.setVersion(concept.getVersion());
        return descriptor;
    }

    public static RelationshipDescriptor createRelationshipDescriptor(String acronym, MultilingualString name, MultilingualString description, Identifier parent, Identifier child, Version version, Integer sortorder) {
        RelationshipDescriptorImpl descriptor = new RelationshipDescriptorImpl();
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setParentConceptId(parent);
        descriptor.setChildConceptId(child);
        descriptor.setVersion(version);
        descriptor.setSortorder(sortorder);
        return descriptor;
    }

    public static RelationshipDescriptor createRelationshipDescriptor(Relationship relationship) {
        RelationshipDescriptorImpl descriptor = new RelationshipDescriptorImpl();
        descriptor.setAcronym(relationship.getAcronym());
        descriptor.setName(relationship.getName());
        descriptor.setDescription(relationship.getDescription());
        descriptor.setParentConceptId(relationship.getParentConcept().getId());
        descriptor.setChildConceptId(relationship.getChildConcept().getId());
        descriptor.setVersion(relationship.getVersion());
        descriptor.setSortorder(relationship.getSortorder());
        return descriptor;
    }
}

