/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;

public class Application
implements IApplication {
    public static final String ID = "org.fao.fi.fishstat.gui";
    public static final Display display = PlatformUI.createDisplay();
    private static ServerSocket socket;
    public static final int SINGLE_INSTANCE_NETWORK_SOCKET = 44311;
    public static final String SINGLE_INSTANCE_SHARED_KEY = "$$NewInstance$$\n";

    public Object start(IApplicationContext context) {
        try {
            System.setProperty("http.keepAlive", "false");
            ApplicationWorkbenchAdvisor awa = new ApplicationWorkbenchAdvisor();
            int returnCode = -1;
            try {
                returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)awa);
            }
            catch (Throwable e) {
                System.out.print(returnCode);
            }
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    public static boolean registerInstance() {
        try {
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            socket = new ServerSocket(44311, 10, InetAddress.getByAddress(byArray));
            socket.setReuseAddress(true);
            System.out.println("Listening for application instances on socket 44311");
            Thread instanceListenerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean socketClosed = false;
                    while (!socketClosed) {
                        if (socket.isClosed()) {
                            socketClosed = true;
                            continue;
                        }
                        try {
                            Socket client = socket.accept();
                            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                            String message = in.readLine();
                            if (Application.SINGLE_INSTANCE_SHARED_KEY.trim().equals(message.trim())) {
                                System.out.println("Shared key matched - new application instance found");
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().forceActive();
                            }
                            in.close();
                            client.close();
                        }
                        catch (IOException e) {
                            socketClosed = true;
                        }
                    }
                }
            });
            instanceListenerThread.start();
        }
        catch (UnknownHostException e) {
            System.out.println(e.getMessage());
            return true;
        }
        catch (IOException e) {
            System.out.println("Port is already taken.  Notifying first instance.");
            try {
                byte[] byArray = new byte[4];
                byArray[0] = 127;
                byArray[3] = 1;
                Socket clientSocket = new Socket(InetAddress.getByAddress(byArray), 44311);
                OutputStream out = clientSocket.getOutputStream();
                out.write(SINGLE_INSTANCE_SHARED_KEY.getBytes());
                out.close();
                clientSocket.close();
                System.out.println("Successfully notified first instance.");
            }
            catch (Exception e1) {
                System.out.println("Error connecting to local port for single instance notification");
                System.out.println(e1.getMessage());
            }
            return false;
        }
        return true;
    }
}

