/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.filter;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.dataset.filter.KeyFilterComposite;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class TimeSeriesFilterDialog
extends TitleAreaDialog
implements IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.gui.dataset.filter.datasetselection";
    private FilterWrapper dimensionSelectionWrapper = null;
    private DatasetProperties properties = null;
    private CTabFolder tabFolder;
    private Button okButton;
    private Button cancelButton;
    private Dimension[] dimensions;

    public TimeSeriesFilterDialog(Shell parentShell, FilterWrapper dimensionSelectionWrapper, DatasetProperties properties) {
        super(parentShell);
        this.setShellStyle(1104);
        this.dimensionSelectionWrapper = dimensionSelectionWrapper;
        this.dimensions = new Dimension[this.dimensionSelectionWrapper.size()];
        int i = 0;
        while (i < this.dimensions.length) {
            this.dimensions[i] = dimensionSelectionWrapper.getDimension(i);
            ++i;
        }
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Dataset filter");
        parent.setBackground(ComponentsCommons.getColor((int)1));
        parent.setBackgroundMode(2);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setVisible(true);
        container.setBackground(ComponentsCommons.getColor((int)1));
        container.setBackgroundMode(2);
        this.tabFolder = new CTabFolder(container, 0x800000);
        this.tabFolder.setVisible(true);
        this.tabFolder.setBackgroundMode(2);
        GridData gd_tabFolder = new GridData(4, 4, true, true);
        gd_tabFolder.heightHint = 480;
        gd_tabFolder.widthHint = 777;
        this.tabFolder.setLayoutData((Object)gd_tabFolder);
        this.tabFolder.setSelectionForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        int tab_size = this.dimensionSelectionWrapper.size();
        this.setTitle(Activator.getLocalString("timeseries.filter.dialog.title"));
        this.setMessage(Activator.getLocalString("timeseries.filter.dialog.subtitle"));
        int i = 0;
        while (i < tab_size) {
            ConceptSelection dimSel = this.dimensionSelectionWrapper.getConceptSelection(i);
            DimensionProperties dimensionProperties = this.properties.getDimensionsProperties(dimSel.getConcept());
            CTabItem keyTabItem = new CTabItem(this.tabFolder, 0);
            try {
                keyTabItem.setText(CoreUtils.getCurrentLangName((Object)this.dimensionSelectionWrapper.getDimension(i), (String)Activator.getLanguage()));
                KeyFilterComposite cmpKeySelector = new KeyFilterComposite((Composite)this.tabFolder, 0, dimSel, dimensionProperties);
                keyTabItem.setControl((Control)cmpKeySelector);
                if (i == 0) {
                    this.tabFolder.setSelection(i);
                }
            }
            catch (Exception e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
                keyTabItem.setText("##EXCEPTION##");
            }
            ++i;
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setBackground(ComponentsCommons.getColor((int)1));
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelButton.setBackground(ComponentsCommons.getColor((int)1));
    }

    public void setTabFocus(int focusTabIndex) {
        this.tabFolder.setSelection(focusTabIndex);
    }

    public void setTabFocus(Concept tabConcept) {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].getConcept().equals(tabConcept)) {
                this.tabFolder.setSelection(i);
            }
            ++i;
        }
    }

    protected Point getInitialSize() {
        return new Point(800, 650);
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        newShell.setBackgroundMode(2);
        super.configureShell(newShell);
        newShell.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/filter.png"));
        newShell.setText(Activator.getLocalString("timeseries.filter.dialog.bartitle"));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                this.ok_action();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void ok_action() throws Exception {
        final boolean relatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");
        TimeSeriesFilterDialog dlg = this;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    CoreRegistry registry = GuiCoreActivator.getDefault().getRegistry();
                    registry.processActionRequest((IActionRequestWrapper)TimeSeriesFilterDialog.this.dimensionSelectionWrapper, relatives, monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        dlg.close();
    }
}

