/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.data;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.properties.dataset.sorting.AdvanceSortDialog;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedComparator;

public class SortHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.data.sort";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<SessionDescriptor> toProcess;
        CoreRegistry coreRegistry = GuiCoreActivator.getDefault().getRegistry();
        final GuiSession session = (GuiSession)coreRegistry.getSessionOnFocus();
        TimeSeriesProperties timeSeriesProperties = session.getTimeseriesProperties();
        MultiSortProperties sortProperties = timeSeriesProperties.getSorter();
        AdvanceSortDialog dialog = new AdvanceSortDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), sortProperties);
        int result = dialog.open();
        boolean relatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");
        List<SessionDescriptor> list = toProcess = relatives ? coreRegistry.findRelatives(session.getDescriptor()) : Arrays.asList(session.getDescriptor());
        if (result == 0) {
            for (SessionDescriptor sessionDescriptor : toProcess) {
                final IViewReference vr = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + sessionDescriptor.getUuid().toString());
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (vr != null) {
                                MultiTableView multiTableView = (MultiTableView)vr.getView(true);
                                multiTableView.setCommonComparator(new UnifiedComparator(session.getTimeseriesProperties()));
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() >= 1);
    }
}

