/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class MainPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private String locale;
    private Button chkSaveWorkingSession;
    public static final String ID = "org.fao.fi.fishstat.gui.preferences.general";
    private Button chkJoinDataset;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 8;
        gridLayout.horizontalSpacing = 8;
        composite.setLayout((Layout)gridLayout);
        this.chkSaveWorkingSession = new Button(composite, 32);
        this.chkSaveWorkingSession.setText(Activator.getLocalString("preferences.general.preferences.save.on.exit"));
        this.chkJoinDataset = new Button(composite, 32);
        this.chkJoinDataset.setText(Activator.getLocalString("preferences.general.preferences.syncro.same.dataset"));
        this.syncroPanel();
        return composite;
    }

    private void syncroPanel() {
        this.chkSaveWorkingSession.setSelection(this.getPreferenceStore().getBoolean("core.persist.work.session"));
        this.chkJoinDataset.setSelection(this.getPreferenceStore().getBoolean("core.join.related.series"));
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Activator.getLocalString("preferences.general.preferences.subtitle"));
        this.setTitle(Activator.getLocalString("preferences.general.preferences.title"));
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void performApply() {
        super.performApply();
    }

    protected void performDefaults() {
        this.chkSaveWorkingSession.setSelection(this.getPreferenceStore().getDefaultBoolean("core.persist.work.session"));
        this.chkJoinDataset.setSelection(this.getPreferenceStore().getDefaultBoolean("core.join.related.series"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("core.persist.work.session", this.chkSaveWorkingSession.getSelection());
        this.getPreferenceStore().setValue("core.join.related.series", this.chkJoinDataset.getSelection());
        return super.performOk();
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    protected void changeLocaleWithMessage() {
        MessageDialog dialog;
        if (!this.locale.equals(Activator.getLanguage()) && (dialog = new MessageDialog(Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getLocalString("label.application.restart"), null, Activator.getLocalString("label.different.locale"), 3, new String[]{"Yes", "No"}, 0)).open() == 0) {
            Activator.changeLocale(this.locale);
            this.dispose();
            PlatformUI.getWorkbench().restart();
        }
    }
}

