/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.sorting;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.properties.dataset.sorting.SingleSorterComposite;

public class DatasetSortingPropertiesComposite
extends Composite
implements Observer {
    private MultiSortProperties properties;
    private SingleSorterComposite[] sorterComposites = null;

    public DatasetSortingPropertiesComposite(Composite parent, int style, MultiSortProperties p) {
        super(parent, style);
        this.properties = p;
        if (this.properties != null) {
            this.properties.addObserver((Observer)this);
        }
        this.initComponents();
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        this.sorterComposites = new SingleSorterComposite[5];
        if (this.properties != null) {
            this.designStrips();
        }
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.wrap = false;
        this.setLayout((Layout)rowLayout);
    }

    private void designStrips() {
        int sorter_size = this.properties.size();
        int i = 0;
        while (i < 5) {
            if (this.sorterComposites[i] != null && !this.sorterComposites[i].isDisposed()) {
                this.sorterComposites[i].dispose();
            }
            if (i < sorter_size) {
                MultiSortElemProperties sorter = (MultiSortElemProperties)this.properties.getColumnSorters().get(i);
                this.sorterComposites[i] = new SingleSorterComposite(this, 0, sorter);
                this.sorterComposites[i].setIndex(i);
            }
            ++i;
        }
    }

    protected void deleteLast() {
        this.properties.removeLastSorter(false);
        this.properties.notifyObservers();
    }

    protected void deleteSelected() {
        SingleSorterComposite[] singleSorterCompositeArray = this.sorterComposites;
        int n = this.sorterComposites.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSorterComposite c = singleSorterCompositeArray[n2];
            if (c != null && !c.isDisposed()) {
                if (c.isSelected()) {
                    this.properties.removeSorter(c.getSorterProperties(), false);
                } else {
                    c.applyData();
                }
            }
            ++n2;
        }
        this.properties.notifyObservers();
    }

    protected void moveUpSelected() {
        SingleSorterComposite[] singleSorterCompositeArray = this.sorterComposites;
        int n = this.sorterComposites.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSorterComposite c = singleSorterCompositeArray[n2];
            if (c != null && !c.isDisposed() && c.isSelected()) {
                c.applyData();
                this.properties.moveSorterUp(c.getSorterProperties(), false);
            }
            ++n2;
        }
        this.properties.notifyObservers();
    }

    protected void moveDownSelected() {
        SingleSorterComposite[] singleSorterCompositeArray = this.sorterComposites;
        int n = this.sorterComposites.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSorterComposite c = singleSorterCompositeArray[n2];
            if (c != null && !c.isDisposed() && c.isSelected()) {
                c.applyData();
                this.properties.moveSorterDown(c.getSorterProperties(), false);
            }
            ++n2;
        }
        this.properties.notifyObservers();
    }

    protected void addNewSorter() {
        this.properties.addNewSorter(true);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.designStrips();
        this.layout(true);
    }

    protected void performApply() {
        SingleSorterComposite[] singleSorterCompositeArray = this.sorterComposites;
        int n = this.sorterComposites.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSorterComposite c = singleSorterCompositeArray[n2];
            if (c != null && !c.isDisposed()) {
                c.applyData();
            }
            ++n2;
        }
    }
}

