/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableSelectionChangeListener;

public abstract class MultiTableAbstractViewer
extends TableViewer {
    protected GuiSession session;
    private TableColumn lastClickedColumn;
    private List<MultiTableAbstractViewer> parallelTables = new LinkedList<MultiTableAbstractViewer>();
    protected Table table = null;
    private int[] lastClickedCell = new int[2];
    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);

    protected abstract void rebuildTable();

    protected abstract void adjournLastFocusEntity(FocusEntity var1);

    public MultiTableAbstractViewer(Composite parent, int style) {
        super(parent, style);
        if (!Beans.isDesignTime()) {
            this.session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        }
        this.table = this.getTable();
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Activator.getDefault().getStatusBarController().setRecordNumber(MultiTableAbstractViewer.this.table.getSelectionIndex());
                ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncEditMenus(MultiTableAbstractViewer.this.table.getSelection().length > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button > 1) {
                    MultiTableAbstractViewer.this.adjournMenuController(event);
                }
            }
        });
        ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncEditMenus(false);
    }

    protected void adjournColumnsHeaders(boolean tooltips) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).setText(this.getColumnHeader(i));
            if (tooltips) {
                this.table.getColumn(i).setToolTipText(this.getColumnTooltip(i));
            }
            ++i;
        }
    }

    protected abstract String getColumnHeader(int var1);

    protected String getColumnTooltip(int column) {
        return null;
    }

    int getColumnsCount() {
        return this.getTable().getColumnCount();
    }

    int getColumnsTotalWidth() {
        int res = 0;
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            res += column.getWidth();
            ++n2;
        }
        return res;
    }

    public int[] getLastClickedCell() {
        return this.lastClickedCell;
    }

    private void adjournMenuController(Event event) {
        Rectangle clientArea = this.table.getClientArea();
        int grid_line_width = this.table.getGridLineWidth();
        Point pt1 = new Point(event.x, event.y);
        Point pt2 = new Point(event.x > grid_line_width ? event.x - grid_line_width : event.x, event.y);
        Point pt3 = new Point(event.x, event.y > grid_line_width ? event.y - grid_line_width : event.y);
        Point pt4 = new Point(event.x > grid_line_width ? event.x - grid_line_width : event.x, event.y > grid_line_width ? event.y - grid_line_width : event.y);
        int index = this.table.getTopIndex();
        while (index < this.table.getItemCount()) {
            boolean visible = false;
            TableItem item = this.table.getItem(index);
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt1) || rect.contains(pt2) || rect.contains(pt3) || rect.contains(pt4)) {
                    if (this.lastClickedCell == null) {
                        this.lastClickedCell = new int[2];
                    }
                    this.lastClickedCell[0] = index;
                    this.lastClickedCell[1] = i;
                    FocusEntity focusEntity = new FocusEntity(i, item.getText(i));
                    this.adjournLastFocusEntity(focusEntity);
                    this.session.setLastFocusEntity(focusEntity);
                    return;
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                this.session.resetFocusEntity();
                return;
            }
            ++index;
        }
    }

    public List<MultiTableAbstractViewer> getParallelTables() {
        return this.parallelTables;
    }

    public TableColumn getLastClickedColumn() {
        return this.lastClickedColumn;
    }

    public void setLastClickedColumn(TableColumn lastClickedColumn) {
        this.lastClickedColumn = lastClickedColumn;
    }

    public void addParallelTable(MultiTableAbstractViewer table) {
        this.parallelTables.add(table);
        this.createSincronizer(table);
        this.addPostSelectionChangedListener(new MultiTableSelectionChangeListener(table));
        table.addPostSelectionChangedListener(new MultiTableSelectionChangeListener(this));
    }

    public void resetSortColumn() {
        if (this.lastClickedColumn != null && !this.lastClickedColumn.isDisposed()) {
            this.lastClickedColumn.getParent().setSortDirection(0);
        }
    }

    public void createSincronizer(final TableViewer parallelTable) {
        if (this.getTable().getVerticalBar() != null) {
            this.getTable().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    int position = ((Table)((ScrollBar)e.widget).getParent()).getTopIndex();
                    if (position != parallelTable.getTable().getTopIndex()) {
                        parallelTable.getTable().setTopIndex(position);
                    }
                }
            });
        }
    }

    protected abstract class ColumnViewerSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int NONE = 0;
        public static final int DESC = -1;
        protected int direction = 0;
        protected TableColumn column;
        protected ColumnViewer viewer;
        protected int idx;

        private void sortBySuper(Viewer viewer, Object[] elements) {
            super.sort(viewer, elements);
        }

        public void sort(final Viewer viewer, final Object[] elements) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ColumnViewerSorter.this.sortBySuper(viewer, elements);
                        }
                    });
                }
            });
        }

        public ColumnViewerSorter(ColumnViewer viewer, TableColumn column, int idx) {
            this.column = column;
            this.viewer = viewer;
            this.idx = idx;
            this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiTableAbstractViewer.this.lastClickedColumn = ColumnViewerSorter.this.column;
                    if (ColumnViewerSorter.this.viewer.getComparator() != null) {
                        if (ColumnViewerSorter.this.viewer.getComparator() == ColumnViewerSorter.this) {
                            int tdirection = ColumnViewerSorter.this.direction;
                            if (tdirection == 1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, -1);
                            } else if (tdirection == -1) {
                                ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 0);
                            }
                        } else {
                            ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                        }
                    } else {
                        ColumnViewerSorter.this.setSorter(ColumnViewerSorter.this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnViewerSorter sorter, int direction) {
            if (direction == 0) {
                this.column.getParent().setSortColumn(null);
                this.column.getParent().setSortDirection(0);
                this.viewer.setComparator(null);
                this.adjoustParallelTablesComparator(null);
            } else {
                this.column.getParent().setSortColumn(this.column);
                sorter.direction = direction;
                if (direction == 1) {
                    this.column.getParent().setSortDirection(128);
                } else {
                    this.column.getParent().setSortDirection(1024);
                }
                if (this.viewer.getComparator() == sorter) {
                    this.viewer.refresh();
                } else {
                    this.viewer.setComparator((ViewerComparator)sorter);
                }
                this.adjoustParallelTablesComparator(sorter);
            }
        }

        private void adjoustParallelTablesComparator(ColumnViewerSorter sorter) {
            for (MultiTableAbstractViewer viewer : MultiTableAbstractViewer.this.parallelTables) {
                viewer.setComparator(sorter);
                viewer.resetSortColumn();
                viewer.refresh();
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.direction * this.doCompare(viewer, e1, e2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }
}

