/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.gui.viewers;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class ConceptSelectionViewersFactory {
    private static ConceptSelectionViewersFactory factory;
    private Attribute nameAttribute;
    private Attribute codeAttribute;

    private ConceptSelectionViewersFactory() {
    }

    public static ConceptSelectionViewersFactory getFactory() {
        if (factory == null) {
            factory = new ConceptSelectionViewersFactory();
        }
        return factory;
    }

    public StructuredViewer createViewer(Composite parent, int style, Class<?> viewerClass, String lang, Object[] parameters) {
        if (viewerClass.equals(ComboViewer.class)) {
            return this.createComboViewer(parent, style, lang, parameters);
        }
        if (viewerClass.equals(ListViewer.class)) {
            return this.createListViewer(parent, style, lang, parameters);
        }
        if (viewerClass.equals(TreeViewer.class)) {
            return this.createTreeViewer(parent, style, lang, parameters);
        }
        return null;
    }

    private ComboViewer createComboViewer(Composite parent, int style, String lang, Object[] parameters) {
        ComboViewer result = new ComboViewer(parent, style);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider((Integer)parameters[0]));
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private ListViewer createListViewer(Composite parent, int style, String lang, Object[] parameters) {
        ListViewer result = new ListViewer(parent, style);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider((Integer)parameters[0]));
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private TreeViewer createTreeViewer(Composite parent, int style, String lang, Object[] parameters) {
        TreeViewer result = new TreeViewer(parent, style);
        result.setContentProvider((IContentProvider)new ConceptChildsContentProvider((Integer)parameters[0]));
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private class ConceptChildsContentProvider
    implements ITreeContentProvider {
        int side = 0;

        public ConceptChildsContentProvider(int side) {
            this.side = side;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ConceptSelection) {
                if (((ConceptSelection)inputElement).getConcept() != null) {
                    ConceptSelectionViewersFactory.this.nameAttribute = ((ConceptSelection)inputElement).getConcept().getNameAttribute();
                    if (((ConceptSelection)inputElement).getConcept().getCodeAttributes().size() > 1) {
                        ConceptSelectionViewersFactory.this.codeAttribute = ((ConceptSelection)inputElement).getConcept().getCodeAttributes().toArray(new Attribute[0])[1];
                    }
                }
                return this.side == 1 ? ((ConceptSelection)inputElement).getIncludes().toArray() : ((ConceptSelection)inputElement).getExcludes().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ConceptsContentProvider
    implements IStructuredContentProvider {
        int side = 0;

        public ConceptsContentProvider(Integer side) {
            this.side = side;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ConceptSelection) {
                if (((ConceptSelection)inputElement).getConcept() != null) {
                    ConceptSelectionViewersFactory.this.nameAttribute = ((ConceptSelection)inputElement).getConcept().getNameAttribute();
                    if (((ConceptSelection)inputElement).getConcept().getCodeAttributes().size() > 1) {
                        ConceptSelectionViewersFactory.this.codeAttribute = ((ConceptSelection)inputElement).getConcept().getCodeAttributes().toArray(new Attribute[0])[1];
                    }
                }
                return this.side == 1 ? ((ConceptSelection)inputElement).getIncludes().toArray() : ((ConceptSelection)inputElement).getExcludes().toArray();
            }
            return null;
        }
    }

    private class ConceptsLabelProvider
    extends LabelProvider {
        private String lang = null;

        public ConceptsLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof ReferenceObject) {
                String result;
                Object res = ((ReferenceObject)element).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute);
                String string = result = res instanceof MultilingualString ? ((MultilingualString)res).getValue(this.lang) : res.toString();
                if (ConceptSelectionViewersFactory.this.codeAttribute != null && (result == null || result.equals(""))) {
                    result = "[" + ConceptSelectionViewersFactory.this.codeAttribute.getAcronym() + "] " + ((ReferenceObject)element).getAttribute(ConceptSelectionViewersFactory.this.codeAttribute).toString();
                }
                return result;
            }
            return super.getText(element);
        }
    }

    private class ConceptsSorter
    extends ViewerComparator {
        private String lang;

        public ConceptsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            try {
                if (c1 instanceof ReferenceObject && c2 instanceof ReferenceObject) {
                    String s1 = ((ReferenceObject)c1).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute) instanceof MultilingualString ? ((MultilingualString)((ReferenceObject)c1).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute)).getValue(this.lang) : ((ReferenceObject)c1).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute).toString();
                    String s2 = ((ReferenceObject)c2).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute) instanceof MultilingualString ? ((MultilingualString)((ReferenceObject)c2).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute)).getValue(this.lang) : ((ReferenceObject)c2).getAttribute(ConceptSelectionViewersFactory.this.nameAttribute).toString();
                    return s1.compareTo(s2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}

