/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.trees;

import java.beans.Beans;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class ReferenceObjectTree
extends Composite {
    private ReferenceObject referenceObject;
    private String lang;
    private Tree tree;
    private TreeColumn tclAttributeName;
    private TreeColumn tclAttributeValue;
    private TreeColumn tclDescription;

    public ReferenceObjectTree(Composite parent, int style, ReferenceObject referenceObject, String lang) {
        super(parent, style);
        this.referenceObject = referenceObject;
        this.lang = lang;
        this.initComponents();
        if (!Beans.isDesignTime()) {
            this.loadReferenceObject();
        }
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.tree = new Tree((Composite)this, 0x10000000);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        GridData gridData_1 = new GridData(4, 4, true, true, 2, 1);
        gridData_1.widthHint = 496;
        this.tree.setLayoutData((Object)gridData_1);
        this.tclAttributeName = new TreeColumn(this.tree, 0);
        this.tclAttributeName.setWidth(120);
        this.tclAttributeName.setText(ComponentsActivator.getDefault().getLocalString("label.attribute.first.upper"));
        this.tclAttributeValue = new TreeColumn(this.tree, 0);
        this.tclAttributeValue.setWidth(150);
        this.tclAttributeValue.setText(ComponentsActivator.getDefault().getLocalString("label.value.first.upper"));
        this.tclDescription = new TreeColumn(this.tree, 0);
        this.tclDescription.setWidth(400);
        this.tclDescription.setText(ComponentsActivator.getDefault().getLocalString("label.description.first.upper"));
    }

    protected void checkSubclass() {
    }

    private void loadReferenceObject() {
        Map attributesMap = this.referenceObject.getAttributes();
        Set attributes = attributesMap.keySet();
        for (Attribute attribute : attributes) {
            if (attribute.getAcronym().equals("ID")) continue;
            TreeItem treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(0, CoreUtils.getCurrentLang((MultilingualString)attribute.getName(), (String)this.lang));
            treeItem.setForeground(0, ComponentsCommons.getColor(12));
            Object value = attributesMap.get(attribute);
            if (value != null) {
                if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                    for (String lang : MultilingualString.LANGUAGES) {
                        TreeItem treeItemLn = new TreeItem(treeItem, 0);
                        treeItemLn.setText(0, "   (" + lang + ")");
                        treeItemLn.setText(1, CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)value), (String)lang) != null ? CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)value), (String)lang) : "");
                        treeItemLn.setForeground(0, ComponentsCommons.getColor(16));
                        treeItemLn.setForeground(1, ComponentsCommons.getColor(10));
                    }
                    treeItem.setExpanded(true);
                } else {
                    treeItem.setText(1, value.toString());
                    treeItem.setForeground(1, ComponentsCommons.getColor(10));
                }
            }
            treeItem.setText(2, CoreUtils.getCurrentLang((MultilingualString)attribute.getDescription(), (String)this.lang));
            treeItem.setForeground(2, ComponentsCommons.getColor(10));
        }
    }

    public void setBackground(Color color) {
        this.tree.setBackground(color);
    }

    public void setForeground(Color color) {
        this.tree.setBackground(color);
    }
}

