/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.management.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.daosupport.exceptions.DAOException;
import org.fao.fi.fishstat.data.common.api.exceptions.ReflectionException;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.ddlutils.DdlUtilsHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.AttributeImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ConceptImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;
import org.fao.fi.fishstat.data.reference.api.impl.RelationshipImpl;
import org.fao.fi.fishstat.data.reference.api.management.ReferenceMetadataManagementService;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.exceptions.ReferenceManagementException;

public class ReferenceMetadataManagementServiceImpl
implements ReferenceMetadataManagementService {
    private static final Map<String, String> CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES = new HashMap<String, String>(){
        private static final long serialVersionUID = -1594307561010908554L;
        {
            this.put("en", "Custom group relationship");
            this.put("fr", "Custom group relationship");
            this.put("es", "Custom group relationship");
            this.put("ar", "Custom group relationship");
            this.put("zh", "Custom group relationship");
            this.put("ru", "Custom group relationship");
        }
    };
    private static final MultilingualString CUSTOM_GROUP_RELATIONSHIP_NAME = new MultilingualString(CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES);
    private static final Map<String, String> CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES = new HashMap<String, String>(){
        private static final long serialVersionUID = -1302381231862295559L;
        {
            this.put("en", "Custom group relationship");
            this.put("fr", "Custom group relationship");
            this.put("es", "Custom group relationship");
            this.put("ar", "Custom group relationship");
            this.put("zh", "Custom group relationship");
            this.put("ru", "Custom group relationship");
        }
    };
    private static final MultilingualString CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION = new MultilingualString(CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES);

    @Override
    public Concept createConcept(ConceptDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Concept descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Concept acronym can not be null");
            }
            Concept existing = ReferenceServiceFactory.getService().getConcept(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Concept with acronym: " + descriptor.getAcronym() + " already exists: " + existing.getName());
            }
            Concept concept = this.addConceptEntry(descriptor);
            Relationship custom_group_relationship = null;
            try {
                custom_group_relationship = this.addCustomGroupRelationshipEntry(concept);
            }
            catch (Exception e) {
                this.removeConceptEntry(concept);
                throw new ReferenceManagementException("Unable to add default custom group relationship: " + e.getMessage(), e);
            }
            try {
                this.createConceptTables(concept);
            }
            catch (Exception e) {
                this.removeRelationshipEntry(custom_group_relationship);
                this.removeConceptEntry(concept);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to create concept tables: " + e.getMessage(), e);
            }
            return concept;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new concept", e);
        }
    }

    private Relationship addCustomGroupRelationshipEntry(Concept concept) throws ReferenceManagementException {
        try {
            GenericDAO relationship_dao = ReferenceServiceHelper.getRmdRelationshipDao();
            Class c = ReferenceServiceHelper.getRmdRelationshipDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object relationship_dto = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(relationship_dto, (String)relationship_dao.generateId());
            Commons.setDTOAttribute(relationship_dto, (String)"PARENT_ID", (Object)CustomGroupFactory.getConcept().getId().stringValue(), String.class);
            Commons.setDTOAttribute(relationship_dto, (String)"CHILD_ID", (Object)concept.getId().stringValue(), String.class);
            Commons.setDTOAttribute(relationship_dto, (String)"ACRONYM", (Object)("CUSTOM_GROUP_" + concept.getAcronym()), String.class);
            Commons.setMultilingualDTOAttribute(relationship_dto, (String)"NAME", (MultilingualString)CUSTOM_GROUP_RELATIONSHIP_NAME);
            Commons.setMultilingualDTOAttribute(relationship_dto, (String)"DESCRIPTION", (MultilingualString)CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION);
            relationship_dao.insert(relationship_dto);
            return new RelationshipImpl(relationship_dto);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add default custom group relationship entry for: " + concept.getAcronym(), e);
        }
    }

    private Collection<Attribute> addAttributeEntries(Collection<AttributeDescriptor> attribute_descriptors) throws ReferenceManagementException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeDescriptor attribute_descriptor : attribute_descriptors) {
            attributes.add(this.addAttributeEntry(attribute_descriptor));
        }
        return attributes;
    }

    private Attribute addAttributeEntry(AttributeDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO attribute_dao = ReferenceServiceHelper.getRmdAttributeDao();
            Class c = ReferenceServiceHelper.getRmdAttributeDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object attribute_dto = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(attribute_dto, (String)attribute_dao.generateId());
            Commons.setDTOAttribute(attribute_dto, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setDTOAttribute(attribute_dto, (String)"CONCEPT_ID", (Object)descriptor.getConceptId().stringValue(), String.class);
            Commons.setDTOAttribute(attribute_dto, (String)"CODE", (Object)(descriptor.isCodeAttribute() ? (short)1 : 0), Short.class);
            Commons.setDTOAttribute(attribute_dto, (String)"NAME", (Object)(descriptor.isNameAttribute() ? (short)1 : 0), Short.class);
            Commons.setDTOAttribute(attribute_dto, (String)"ATTRIBUTE_TYPE", (Object)descriptor.getType().toString(), String.class);
            Commons.setDTOAttribute(attribute_dto, (String)"ATTRIBUTE_SIZE", (Object)descriptor.getSize(), Short.class);
            Commons.setDTOAttribute(attribute_dto, (String)"ATTRIBUTE_SCALE", (Object)descriptor.getScale(), Short.class);
            Commons.setMultilingualDTOAttribute(attribute_dto, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(attribute_dto, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            attribute_dao.insert(attribute_dto);
            return new AttributeImpl(attribute_dto);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add attribute entry for: " + descriptor.getAcronym(), e);
        }
    }

    private Concept addConceptEntry(ConceptDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO concept_dao = ReferenceServiceHelper.getRmdConceptDao();
            Class c = ReferenceServiceHelper.getRmdConceptDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object concept_dto = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(concept_dto, (String)concept_dao.generateId());
            Commons.setDTOAttribute(concept_dto, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setMultilingualDTOAttribute(concept_dto, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(concept_dto, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            VersionHelper.setVersion(concept_dto, (Version)descriptor.getVersion());
            concept_dao.insert(concept_dto);
            return new ConceptImpl(concept_dto);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add concept entry for: " + descriptor.getAcronym(), e);
        }
    }

    private void createConceptTables(Concept concept) throws ReferenceManagementException {
        try {
            Database model = DdlUtilsHelper.getDatabase();
            this.createReferenceObjectTable(concept.getAcronym(), model);
            this.createCustomGroupRelationshipTable(concept, model);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference tables for: " + concept.getAcronym(), e);
        }
    }

    private void createReferenceObjectTable(String concept_acronym, Database model) throws ReferenceManagementException {
        try {
            Table table = new Table();
            table.setSchema("FISHSTAT");
            table.setName("REF_" + concept_acronym.toUpperCase(Locale.ENGLISH));
            Column id = new Column();
            id.setName("ID");
            id.setTypeCode(AttributeType.STRING.getJdbcType());
            id.setSize(String.valueOf(20));
            id.setPrimaryKey(true);
            table.addColumn(id);
            model.addTable(table);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference objects table for: " + concept_acronym, e);
        }
    }

    private void createCustomGroupRelationshipTable(Concept concept, Database model) throws ReferenceManagementException {
        try {
            Concept custom_group = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
            RelationshipDescriptor relationship_descriptor = DescriptorsFactory.createRelationshipDescriptor("CUSTOM_GROUP_" + concept.getAcronym(), CUSTOM_GROUP_RELATIONSHIP_NAME, CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION, custom_group.getId(), concept.getId(), null, null);
            this.createRelationshipTable(relationship_descriptor.getAcronym(), custom_group, concept, model);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create custom group relationship table for: " + concept.getAcronym(), e);
        }
    }

    private void createRelationshipTable(String relationship_acronym, Concept parent, Concept child, Database model) throws ReferenceManagementException {
        try {
            Table table = new Table();
            table.setSchema("FISHSTAT");
            table.setName("REL_" + relationship_acronym.toUpperCase(Locale.ENGLISH));
            Column id = new Column();
            id.setName("ID");
            id.setTypeCode(AttributeType.STRING.getJdbcType());
            id.setSize(String.valueOf(20));
            id.setPrimaryKey(true);
            Column parent_id = new Column();
            parent_id.setName("PARENT_ID");
            parent_id.setTypeCode(AttributeType.STRING.getJdbcType());
            parent_id.setSize(String.valueOf(20));
            Column child_id = new Column();
            child_id.setName("CHILD_ID");
            child_id.setTypeCode(AttributeType.STRING.getJdbcType());
            child_id.setSize(String.valueOf(20));
            table.addColumns(Arrays.asList(id, parent_id, child_id));
            Table parent_table = model.findTable("REF_" + parent.getAcronym().toUpperCase(Locale.ENGLISH));
            Column parent_table_id = parent_table.findColumn("ID");
            Table child_table = model.findTable("REF_" + child.getAcronym().toUpperCase(Locale.ENGLISH));
            Column child_table_id = child_table.findColumn("ID");
            Reference parent_id_ref = new Reference(parent_id, parent_table_id);
            ForeignKey parent_id_fk = new ForeignKey(String.valueOf(table.getName()) + "_PARENT_FK");
            parent_id_fk.setForeignTable(parent_table);
            parent_id_fk.addReference(parent_id_ref);
            parent_id_fk.setAutoIndexPresent(true);
            parent_id_fk.setOnDelete(CascadeActionEnum.CASCADE);
            parent_id_fk.setOnUpdate(CascadeActionEnum.CASCADE);
            Reference child_id_ref = new Reference(child_id, child_table_id);
            ForeignKey child_id_fk = new ForeignKey(String.valueOf(table.getName()) + "_CHILD_FK");
            child_id_fk.setForeignTable(child_table);
            child_id_fk.addReference(child_id_ref);
            child_id_fk.setAutoIndexPresent(true);
            child_id_fk.setOnDelete(CascadeActionEnum.CASCADE);
            child_id_fk.setOnUpdate(CascadeActionEnum.CASCADE);
            table.addForeignKeys(Arrays.asList(parent_id_fk, child_id_fk));
            IndexColumn parent_id_idx_column = new IndexColumn(parent_id);
            IndexColumn child_id_idx_column = new IndexColumn(child_id);
            NonUniqueIndex parent_child_id_idx = new NonUniqueIndex();
            parent_child_id_idx.setName(String.valueOf(table.getName()) + "_IDX");
            parent_child_id_idx.addColumn(parent_id_idx_column);
            parent_child_id_idx.addColumn(child_id_idx_column);
            table.addIndex((Index)parent_child_id_idx);
            model.addTable(table);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference relationship table for: " + relationship_acronym, e);
        }
    }

    @Override
    public Relationship createRelationship(RelationshipDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Relationship descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Relationship acronym can not be null");
            }
            Concept parent = ReferenceServiceFactory.getService().getConcept(descriptor.getParentConceptId());
            Concept child = ReferenceServiceFactory.getService().getConcept(descriptor.getChildConceptId());
            if (parent == null || child == null) {
                throw new IllegalArgumentException("Relationship parent/child can not be null");
            }
            Relationship existing = ReferenceServiceFactory.getService().getRelationship(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Relationship with acronym: " + descriptor.getAcronym() + " already exists: " + existing.getName());
            }
            Relationship relationship = this.addRelationshipEntry(descriptor);
            try {
                Database model = DdlUtilsHelper.getDatabase();
                this.createRelationshipTable(descriptor.getAcronym(), parent, child, model);
                DdlUtilsHelper.alterDatabase((Database)model);
                DdlUtilsHelper.reloadDatabase();
                RegistryFactory.getRegistry((Object)parent).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)child).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.RELATIONSHIP_CHANGE);
            }
            catch (Exception e) {
                this.removeRelationshipEntry(relationship);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to create reference relationship for: " + descriptor.getAcronym(), e);
            }
            return relationship;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new relationship", e);
        }
    }

    private Relationship addRelationshipEntry(RelationshipDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO relationship_dao = ReferenceServiceHelper.getRmdRelationshipDao();
            Class c = ReferenceServiceHelper.getRmdRelationshipDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object relationship_dto = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(relationship_dto, (String)relationship_dao.generateId());
            Commons.setDTOAttribute(relationship_dto, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setMultilingualDTOAttribute(relationship_dto, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(relationship_dto, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            Commons.setDTOAttribute(relationship_dto, (String)"SORT_ORDER", (Object)descriptor.getSortorder(), Integer.class);
            Commons.setDTOAttribute(relationship_dto, (String)"PARENT_ID", (Object)descriptor.getParentConceptId().stringValue(), String.class);
            Commons.setDTOAttribute(relationship_dto, (String)"CHILD_ID", (Object)descriptor.getChildConceptId().stringValue(), String.class);
            VersionHelper.setVersion(relationship_dto, (Version)descriptor.getVersion());
            relationship_dao.insert(relationship_dto);
            return new RelationshipImpl(relationship_dto);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add relationship entry for: " + descriptor.getAcronym(), e);
        }
    }

    @Override
    public Attribute createAttribute(AttributeDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Attribute descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Attribute acronym can not be null");
            }
            if (descriptor.getType() == null) {
                throw new IllegalArgumentException("Attribute type can not be null");
            }
            if (descriptor.getConceptId() == null) {
                throw new IllegalArgumentException("Concept can not be null");
            }
            if ((descriptor.getType().equals((Object)AttributeType.STRING) || descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) && descriptor.getSize() <= 0) {
                throw new IllegalArgumentException("Positive size must be specified");
            }
            Concept concept = ReferenceServiceFactory.getService().getConcept(descriptor.getConceptId());
            if (concept == null) {
                throw new IllegalArgumentException("Concept can not be found");
            }
            Attribute existing = concept.getAttribute(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Concept attribute with acronym: " + descriptor.getAcronym() + " already defined: " + existing.getName());
            }
            Attribute attribute = this.addAttributeEntry(descriptor);
            try {
                Database model = DdlUtilsHelper.getDatabase();
                this.addAttributeColumn(model, descriptor, concept.getAcronym());
                DdlUtilsHelper.alterDatabase((Database)model);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
            }
            catch (Exception e) {
                this.removeAttributeEntry(attribute);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to add attribute column: " + e.getLocalizedMessage(), e);
            }
            return attribute;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new attribute", e);
        }
    }

    @Override
    public void createAttributes(Set<AttributeDescriptor> descriptors) throws ReferenceManagementException {
        try {
            Database model = DdlUtilsHelper.getDatabase();
            for (AttributeDescriptor descriptor : descriptors) {
                if (descriptor == null) {
                    throw new IllegalArgumentException("Attribute descriptor can not be null");
                }
                if (descriptor.getAcronym() == null) {
                    throw new IllegalArgumentException("Attribute acronym can not be null");
                }
                if (descriptor.getType() == null) {
                    throw new IllegalArgumentException("Attribute type can not be null");
                }
                if (descriptor.getConceptId() == null) {
                    throw new IllegalArgumentException("Concept can not be null");
                }
                if ((descriptor.getType().equals((Object)AttributeType.STRING) || descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) && descriptor.getSize() <= 0) {
                    throw new IllegalArgumentException("Positive size must be specified");
                }
                Concept concept = ReferenceServiceFactory.getService().getConcept(descriptor.getConceptId());
                if (concept == null) {
                    throw new IllegalArgumentException("Concept can not be found");
                }
                Attribute existing = concept.getAttribute(descriptor.getAcronym());
                if (existing != null) {
                    throw new IllegalArgumentException("Concept attribute with acronym: " + descriptor.getAcronym() + " already defined: " + existing.getName());
                }
                Attribute attribute = this.addAttributeEntry(descriptor);
                try {
                    this.addAttributeColumn(model, descriptor, concept.getAcronym());
                    RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                    RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
                }
                catch (Exception e) {
                    this.removeAttributeEntry(attribute);
                    DdlUtilsHelper.reloadDatabase();
                    throw new ReferenceManagementException("Unable to add attribute column: " + e.getLocalizedMessage(), e);
                }
            }
            DdlUtilsHelper.alterDatabase((Database)model);
            DdlUtilsHelper.reloadDatabase();
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new attribute", e);
        }
    }

    private ConceptDescriptor removeConceptEntry(Concept concept) throws DAOException, ReflectionException {
        ConceptDescriptor removed = DescriptorsFactory.createConceptDescriptor(concept);
        GenericDAO concept_dao = ReferenceServiceHelper.getRmdConceptDao();
        Object concept_dto = concept_dao.findById(concept.getId().stringValue());
        concept_dao.delete(Commons.getDTOPk((Object)concept_dto));
        return removed;
    }

    private Collection<AttributeDescriptor> removeConceptAttributeEntries(Concept concept) throws ReferenceServiceException, DAOException, ReflectionException {
        ArrayList<AttributeDescriptor> removed = new ArrayList<AttributeDescriptor>();
        for (Attribute attribute : concept.getAttributes()) {
            if (attribute.getAcronym().equals("ID")) continue;
            removed.add(this.removeAttributeEntry(attribute));
        }
        return removed;
    }

    private RelationshipDescriptor removeRelationshipEntry(Relationship relationship) throws DAOException, ReflectionException {
        RelationshipDescriptor descriptor = DescriptorsFactory.createRelationshipDescriptor(relationship);
        GenericDAO relationship_dao = ReferenceServiceHelper.getRmdRelationshipDao();
        Object relationship_dto = relationship_dao.findById(relationship.getId().stringValue());
        relationship_dao.delete(Commons.getDTOPk((Object)relationship_dto));
        return descriptor;
    }

    private void removeConceptReferenceTable(String concept_acronym, Database model) {
        Table table = model.findTable("REF_" + concept_acronym);
        model.removeTable(table);
    }

    @Override
    public void removeAttribute(Attribute attribute) throws ReferenceManagementException {
        try {
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute can not be null");
            }
            if (attribute.getAcronym().equals("ID")) {
                throw new IllegalArgumentException("Can not remove ID attribute");
            }
            Concept concept = attribute.getConcept();
            AttributeDescriptor descriptor = this.removeAttributeEntry(attribute);
            try {
                this.removeAttributeColumn(concept.getAcronym(), descriptor.getAcronym(), descriptor.isCodeAttribute());
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
            }
            catch (Exception e) {
                this.addAttributeEntry(descriptor);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to remove attribute column: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove reference attribute: " + attribute, e);
        }
    }

    private void removeAttributeColumn(String concept_acronym, String attribute_acronym, boolean is_code) throws Exception {
        Database model = DdlUtilsHelper.getDatabase();
        Table table = model.findTable("REF_" + concept_acronym);
        Column to_be_removed = table.findColumn(attribute_acronym);
        if (to_be_removed != null) {
            List<Index> indices = Arrays.asList(table.getIndices());
            for (Index index : indices) {
                if (!index.hasColumn(to_be_removed)) continue;
                table.removeIndex(index);
            }
            table.removeColumn(to_be_removed);
            DdlUtilsHelper.alterDatabase((Database)model);
        }
    }

    private void addAttributeColumn(Database model, AttributeDescriptor descriptor, String conceptAcronym) throws Exception {
        Table table = model.findTable("REF_" + conceptAcronym, false);
        if (table != null) {
            ArrayList<UniqueIndex> indices = new ArrayList<UniqueIndex>();
            if (descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                for (String language : MultilingualString.LANGUAGES) {
                    Column column = new Column();
                    column.setName(String.valueOf(descriptor.getAcronym().toUpperCase(Locale.ENGLISH)) + "_" + language.toUpperCase(Locale.ENGLISH));
                    column.setDescription(descriptor.getDescription().getValue(language));
                    column.setTypeCode(descriptor.getType().getJdbcType());
                    column.setSize(descriptor.getSize() == 0 ? null : String.valueOf(descriptor.getSize()));
                    column.setScale((int)descriptor.getScale());
                    table.addColumn(column);
                }
            } else {
                Column column = new Column();
                column.setName(descriptor.getAcronym().toUpperCase(Locale.ENGLISH));
                column.setDescription(descriptor.getDescription().getValue("en"));
                column.setTypeCode(descriptor.getType().getJdbcType());
                column.setSize(descriptor.getSize() == 0 ? null : String.valueOf(descriptor.getSize()));
                column.setScale((int)descriptor.getScale());
                if (descriptor.isCodeAttribute()) {
                    UniqueIndex index = new UniqueIndex();
                    index.setName("UNQ_" + table.getName() + "_" + column.getName());
                    IndexColumn index_column = new IndexColumn(column);
                    index.addColumn(index_column);
                    indices.add(index);
                }
                table.addColumn(column);
            }
            if (indices.size() > 0) {
                table.addIndices(indices);
            }
        }
    }

    private AttributeDescriptor removeAttributeEntry(Attribute attribute) throws DAOException, ReflectionException {
        AttributeDescriptor removed = DescriptorsFactory.createAttributeDescriptor(attribute);
        GenericDAO attribute_dao = ReferenceServiceHelper.getRmdAttributeDao();
        Object attribute_dto = attribute_dao.findById(attribute.getId().stringValue());
        attribute_dao.delete(Commons.getDTOPk((Object)attribute_dto));
        return removed;
    }

    @Override
    public void removeConcept(Concept concept) throws ReferenceManagementException {
        try {
            if (concept == null) {
                throw new IllegalArgumentException("Concept can not be null");
            }
            Collection<RelationshipDescriptor> relationship_descriptors = this.removeRelationshipEntries(concept.getRelationships());
            Collection<AttributeDescriptor> attribute_descriptors = null;
            try {
                attribute_descriptors = this.removeConceptAttributeEntries(concept);
            }
            catch (Exception e) {
                this.addRelationshipEntries(relationship_descriptors);
                throw new ReferenceManagementException("Unable to remove concept attribute metadata entries: " + e.getMessage(), e);
            }
            ConceptDescriptor concept_descriptor = null;
            try {
                concept_descriptor = this.removeConceptEntry(concept);
            }
            catch (Exception e) {
                this.addRelationshipEntries(relationship_descriptors);
                this.addAttributeEntries(attribute_descriptors);
                throw new ReferenceManagementException("Unable to remove concept metadata entry: " + e.getMessage(), e);
            }
            try {
                Database model = DdlUtilsHelper.getDatabase();
                for (RelationshipDescriptor relationship_descriptor : relationship_descriptors) {
                    this.removeRelationshipTable(relationship_descriptor.getAcronym(), model);
                }
                this.removeConceptReferenceTable(concept_descriptor.getAcronym(), model);
                DdlUtilsHelper.alterDatabase((Database)model);
            }
            catch (Exception e) {
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to remove concept table(s): " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove reference concept: " + concept, e);
        }
    }

    private void addRelationshipEntries(Collection<RelationshipDescriptor> relationshipDescriptors) throws ReferenceManagementException {
        for (RelationshipDescriptor descriptor : relationshipDescriptors) {
            this.addRelationshipEntry(descriptor);
        }
    }

    private Collection<RelationshipDescriptor> removeRelationshipEntries(Collection<Relationship> relationships) throws DAOException, ReflectionException {
        ArrayList<RelationshipDescriptor> removed = new ArrayList<RelationshipDescriptor>();
        for (Relationship relationship : relationships) {
            removed.add(this.removeRelationshipEntry(relationship));
        }
        return removed;
    }

    @Override
    public void removeRelationship(Relationship relationship) throws ReferenceManagementException {
        try {
            if (relationship == null) {
                throw new IllegalArgumentException("Relationship can not be null");
            }
            Concept parent = relationship.getParentConcept();
            Concept child = relationship.getChildConcept();
            Database model = DdlUtilsHelper.getDatabase();
            this.removeRelationshipTable(relationship.getAcronym(), model);
            this.removeRelationshipEntry(relationship);
            DdlUtilsHelper.alterDatabase((Database)model);
            RegistryFactory.getRegistry((Object)parent).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
            RegistryFactory.getRegistry((Object)child).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.RELATIONSHIP_CHANGE);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove relationship: " + relationship, e);
        }
    }

    private void removeRelationshipTable(String relationship_acronym, Database model) {
        Table table = model.findTable("REL_" + relationship_acronym);
        model.removeTable(table);
    }
}

